/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.construct.Pipeline;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.MuleJAXWSInvoker;
import org.mule.module.cxf.builder.AbstractInboundMessageProcessorBuilder;
import org.mule.module.cxf.i18n.CxfMessages;
import org.mule.service.ServiceCompositeMessageSource;

public class WebServiceMessageProcessorBuilder
extends AbstractInboundMessageProcessorBuilder
implements FlowConstructAware {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private DataBinding databinding;
    private String frontend = "jaxws";
    private FlowConstruct flowConstruct;
    private Service muleService;
    private Class<?> serviceClass;

    @Override
    protected ServerFactoryBean createServerFactory() throws Exception {
        ServerFactoryBean sfb;
        if ("simple".equals(this.frontend)) {
            sfb = new ServerFactoryBean();
            sfb.setDataBinding((DataBinding)new AegisDatabinding());
        } else if ("jaxws".equals(this.frontend)) {
            sfb = new JaxWsServerFactoryBean();
        } else {
            throw new CreateException(CxfMessages.invalidFrontend(this.frontend), (Object)this);
        }
        if (this.serviceClass == null) {
            this.serviceClass = this.getTargetClass(this.muleService);
        }
        sfb.setServiceClass(this.serviceClass);
        this.logger.info((Object)("Built CXF Inbound MessageProcessor for service class " + this.serviceClass.getName()));
        if (this.databinding != null) {
            sfb.setDataBinding(this.databinding);
        }
        if (this.muleService != null && this.muleService.getComponent() instanceof JavaComponent) {
            sfb.setServiceBean(((JavaComponent)this.muleService.getComponent()).getObjectFactory().getInstance(this.muleContext));
        }
        if (this.getService() != null && this.getNamespace() != null) {
            sfb.setServiceName(new QName(this.getNamespace(), this.getService()));
        }
        return sfb;
    }

    @Override
    protected Invoker createInvoker(CxfInboundMessageProcessor processor) {
        Object invoker = super.createInvoker(processor);
        if ("jaxws".equals(this.frontend)) {
            invoker = new MuleJAXWSInvoker((Invoker)invoker);
        }
        return invoker;
    }

    protected Class<?> getTargetClass(Service service) throws MuleException, ClassNotFoundException {
        if (service == null) {
            throw new DefaultMuleException(CxfMessages.serviceClassRequiredWithPassThrough());
        }
        Component component = service.getComponent();
        if (!(component instanceof JavaComponent)) {
            throw new DefaultMuleException(CxfMessages.serviceClassRequiredWithPassThrough());
        }
        try {
            return ((JavaComponent)component).getObjectType();
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    @Override
    protected String getAddress() {
        if (this.flowConstruct != null) {
            MessageSource source;
            if (this.flowConstruct instanceof Service) {
                List endpoints;
                MessageSource source2 = ((Service)this.flowConstruct).getMessageSource();
                if (source2 instanceof InboundEndpoint) {
                    return ((InboundEndpoint)source2).getEndpointURI().toString();
                }
                if (source2 instanceof ServiceCompositeMessageSource && (endpoints = ((ServiceCompositeMessageSource)this.muleService.getMessageSource()).getEndpoints()).size() > 0) {
                    return ((InboundEndpoint)endpoints.get(0)).getEndpointURI().toString();
                }
            } else if (this.flowConstruct instanceof Pipeline && (source = ((Pipeline)this.flowConstruct).getMessageSource()) instanceof InboundEndpoint) {
                return ((InboundEndpoint)source).getEndpointURI().toString();
            }
        }
        return "http://internalMuleCxfRegistry/" + ((Object)((Object)this)).hashCode();
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (flowConstruct instanceof Service) {
            this.muleService = (Service)flowConstruct;
        }
    }

    public String getFrontend() {
        return this.frontend;
    }

    public void setFrontend(String frontend) {
        this.frontend = frontend;
    }

    public DataBinding getDatabinding() {
        return this.databinding;
    }

    public void setDatabinding(DataBinding databinding) {
        this.databinding = databinding;
    }
}

