/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.StaxValidationManager;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.ServiceInfo;
import org.mule.module.xml.stax.ReversibleXMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxySchemaValidationInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(ProxySchemaValidationInInterceptor.class);
    private ServiceInfo service;
    private Bus bus;

    public ProxySchemaValidationInInterceptor(Bus bus, ServiceInfo service) {
        super("read");
        this.bus = bus;
        this.service = service;
        this.addBefore(StartBodyInterceptor.class.getName());
        this.addAfter(ReadHeadersInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xmlReader instanceof ReversibleXMLStreamReader) {
            xmlReader = ((ReversibleXMLStreamReader)xmlReader).getDelegateReader();
        }
        try {
            this.setSchemaInMessage(message, xmlReader);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("SCHEMA_ERROR", LOG, new Object[0]), (Throwable)e);
        }
    }

    private void setSchemaInMessage(Message message, XMLStreamReader reader) throws XMLStreamException {
        StaxValidationManager mgr;
        Object en = message.getContextualProperty("schema-validation-enabled");
        if ((Boolean.TRUE.equals(en) || "true".equals(en)) && (mgr = (StaxValidationManager)this.bus.getExtension(StaxValidationManager.class)) != null) {
            mgr.setupValidation(reader, this.service);
        }
    }
}

