/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.cxf.support.AbstractMuleHeaderInterceptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleHeadersInInterceptor
extends AbstractMuleHeaderInterceptor {
    public MuleHeadersInInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message m) throws Fault {
        String corSeq;
        String corGroupSize;
        String corId;
        Node child;
        if (!(m instanceof SoapMessage)) {
            return;
        }
        SoapMessage message = (SoapMessage)m;
        if (!message.hasHeaders()) {
            return;
        }
        Header mule_header = message.getHeader(MULE_HEADER_Q);
        if (mule_header == null) {
            return;
        }
        Object obj = mule_header.getObject();
        if (!(obj instanceof Element)) {
            return;
        }
        Element header_element = (Element)obj;
        NodeList mule_headers = header_element.getChildNodes();
        int idx = 0;
        while ((child = mule_headers.item(idx++)) != null) {
            Element child_el;
            if (child.getNodeType() != 1 || (child_el = (Element)child).getNamespaceURI() == null || !child_el.getNamespaceURI().equals("http://www.muleumo.org/providers/soap/1.0") || !SUPPORTED_HEADERS.contains(child_el.getLocalName())) continue;
            message.put(child_el.getLocalName(), (Object)this.collectTextFrom(child_el));
        }
        MuleMessage reqMsg = ((MuleEvent)message.getExchange().get((Object)"mule.event")).getMessage();
        String replyTo = (String)message.get((Object)"MULE_REPLYTO");
        if (replyTo != null) {
            reqMsg.setReplyTo((Object)replyTo);
        }
        if ((corId = (String)message.get((Object)"MULE_CORRELATION_ID")) != null) {
            reqMsg.setCorrelationId(corId);
        }
        if ((corGroupSize = (String)message.get((Object)"MULE_CORRELATION_GROUP_SIZE")) != null) {
            reqMsg.setCorrelationGroupSize(Integer.valueOf(corGroupSize).intValue());
        }
        if ((corSeq = (String)message.get((Object)"MULE_CORRELATION_SEQUENCE")) != null) {
            reqMsg.setCorrelationSequence(Integer.valueOf(corSeq).intValue());
        }
    }

    public Set<QName> getUnderstoodHeaders() {
        return UNDERSTOOD_HEADERS;
    }

    private String collectTextFrom(Element e) {
        Node n;
        NodeList children = e.getChildNodes();
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        while ((n = children.item(idx++)) != null) {
            if (n.getNodeType() != 3) continue;
            sb.append(((Text)n).getTextContent());
        }
        return sb.toString();
    }
}

