/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleProtocolHeadersOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public MuleProtocolHeadersOutInterceptor() {
        super("pre-stream");
        this.getAfter().add(AttachmentOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"mule.event");
        MuleMessage muleMsg = event.getMessage();
        if (muleMsg == null) {
            return;
        }
        this.extractAndSetContentType(message, muleMsg);
        this.extractAndSet(message, muleMsg, Message.RESPONSE_CODE, "http.status");
        String method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        if (method == null) {
            method = "POST";
        }
        muleMsg.setOutboundProperty("http.method", (Object)method);
        Map reqHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (reqHeaders != null) {
            for (Map.Entry e : reqHeaders.entrySet()) {
                String key = (String)e.getKey();
                String val = this.format((List)e.getValue());
                muleMsg.setOutboundProperty(key, (Object)val);
            }
        }
        if (!Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"))) {
            message.getInterceptorChain().pause();
        }
    }

    private void extractAndSet(Message message, MuleMessage muleMsg, String cxfHeader, String muleHeader) {
        Object val = message.get((Object)cxfHeader);
        if (val != null) {
            muleMsg.setOutboundProperty(muleHeader, val);
        }
    }

    private void extractAndSetContentType(Message message, MuleMessage muleMsg) {
        String ct = (String)message.get((Object)"Content-Type");
        if (ct != null) {
            String encoding = this.getEncoding(message);
            if (ct.indexOf("charset") == -1) {
                ct = ct + "; charset=" + encoding;
            }
            muleMsg.setOutboundProperty("Content-Type", (Object)ct);
        }
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        return encoding;
    }

    private String format(List<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : value) {
            if (!first) {
                sb.append(", ");
                first = false;
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

