/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.mule.api.lifecycle.CreateException;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.builder.AbstractOutboundMessageProcessorBuilder;

public class LocalClientMessageProcessorBuilder
extends AbstractOutboundMessageProcessorBuilder {
    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
    }

    protected Client createClient() throws CreateException, Exception {
        String uri = this.getAddress();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        idx = uri.indexOf(64);
        int slashIdx = uri.indexOf("//");
        if (idx != -1 && slashIdx != -1) {
            uri = uri.substring(0, slashIdx + 2) + uri.substring(idx + 1);
        }
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactoryForUri(uri);
        if (df == null) {
            throw new Exception("Could not find a destination factory for uri " + uri);
        }
        Destination dest = df.getDestination(ei);
        MessageObserver mo = dest.getMessageObserver();
        if (mo instanceof ChainInitiationObserver) {
            ChainInitiationObserver cMo = (ChainInitiationObserver)mo;
            Endpoint cxfEP = cMo.getEndpoint();
            return new ClientImpl(this.getBus(), cxfEP);
        }
        throw new Exception("Could not create client! No Server was found directly on the endpoint: " + uri);
    }
}

