/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.CxfPayloadToArguments;
import org.mule.module.cxf.support.MuleHeadersInInterceptor;
import org.mule.module.cxf.support.MuleHeadersOutInterceptor;
import org.mule.module.cxf.support.MuleProtocolHeadersOutInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutboundMessageProcessorBuilder
implements MessageProcessorBuilder,
MuleContextAware {
    protected Client client;
    protected String defaultMethodName;
    protected Method defaultMethod;
    protected CxfConfiguration configuration;
    protected List<Interceptor> inInterceptors;
    protected List<Interceptor> inFaultInterceptors;
    protected List<Interceptor> outInterceptors;
    protected List<Interceptor> outFaultInterceptors;
    protected DataBinding databinding;
    protected List<AbstractFeature> features;
    protected String wsdlLocation;
    protected boolean mtomEnabled;
    protected boolean enableMuleSoapHeaders = true;
    protected CxfPayloadToArguments payloadToArguments = CxfPayloadToArguments.NULL_PAYLOAD_AS_PARAMETER;
    protected Map<String, Object> properties;
    protected MuleContext muleContext;
    protected String address;
    protected String operation;

    public CxfOutboundMessageProcessor build() throws MuleException {
        if (this.muleContext == null) {
            throw new IllegalStateException("MuleContext must be supplied.");
        }
        if (this.configuration == null) {
            this.configuration = CxfConfiguration.getConfiguration(this.muleContext);
        }
        try {
            this.client = this.createClient();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        this.addInterceptors(this.client.getInInterceptors(), this.inInterceptors);
        this.addInterceptors(this.client.getInFaultInterceptors(), this.inFaultInterceptors);
        this.addInterceptors(this.client.getOutInterceptors(), this.outInterceptors);
        this.addInterceptors(this.client.getOutFaultInterceptors(), this.outFaultInterceptors);
        this.client.setThreadLocalRequestContext(true);
        this.configureClient(this.client);
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                f.initialize(this.client, this.getBus());
            }
        }
        if (this.mtomEnabled) {
            this.client.getEndpoint().put((Object)"mtom-enabled", (Object)this.mtomEnabled);
        }
        this.addMuleInterceptors();
        CxfOutboundMessageProcessor processor = this.createMessageProcessor();
        processor.setOperation(this.operation);
        this.configureMessageProcessor(processor);
        processor.setPayloadToArguments(this.payloadToArguments);
        return processor;
    }

    protected CxfOutboundMessageProcessor createMessageProcessor() {
        CxfOutboundMessageProcessor processor = new CxfOutboundMessageProcessor(this.client);
        return processor;
    }

    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
    }

    protected void configureClient(Client client) {
    }

    protected Bus getBus() {
        return this.configuration.getCxfBus();
    }

    protected abstract Client createClient() throws CreateException, Exception;

    public Client getClient() {
        return this.client;
    }

    private void addInterceptors(List<Interceptor> col, List<Interceptor> supplied) {
        if (supplied != null) {
            col.addAll(supplied);
        }
    }

    protected String getAddress() {
        if (this.address == null) {
            return "http://host";
        }
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    protected void createClientFromLocalServer() throws Exception {
    }

    protected void addMuleInterceptors() {
        if (this.enableMuleSoapHeaders) {
            this.client.getInInterceptors().add(new MuleHeadersInInterceptor());
            this.client.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
            this.client.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            this.client.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
        this.client.getOutInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        this.client.getOutFaultInterceptors().add(new MuleProtocolHeadersOutInterceptor());
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public DataBinding getDatabinding() {
        return this.databinding;
    }

    public void setDatabinding(DataBinding databinding) {
        this.databinding = databinding;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public List<Interceptor> getInInterceptors() {
        return this.inInterceptors;
    }

    public void setInInterceptors(List<Interceptor> inInterceptors) {
        this.inInterceptors = inInterceptors;
    }

    public List<Interceptor> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    public void setInFaultInterceptors(List<Interceptor> inFaultInterceptors) {
        this.inFaultInterceptors = inFaultInterceptors;
    }

    public List<Interceptor> getOutInterceptors() {
        return this.outInterceptors;
    }

    public void setOutInterceptors(List<Interceptor> outInterceptors) {
        this.outInterceptors = outInterceptors;
    }

    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor> outFaultInterceptors) {
        this.outFaultInterceptors = outFaultInterceptors;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public CxfConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CxfConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnableMuleSoapHeaders() {
        return this.enableMuleSoapHeaders;
    }

    public void setEnableMuleSoapHeaders(boolean enableMuleSoapHeaders) {
        this.enableMuleSoapHeaders = enableMuleSoapHeaders;
    }

    public CxfPayloadToArguments getPayloadToArguments() {
        return this.payloadToArguments;
    }

    public void setPayloadToArguments(CxfPayloadToArguments payloadToArguments) {
        this.payloadToArguments = payloadToArguments;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

