/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleSessionHandler;
import org.mule.RegistryContext;
import org.mule.RequestContext;
import org.mule.api.FutureMessageResult;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.SessionHandler;
import org.mule.context.notification.AdminNotification;
import org.mule.security.MuleCredentials;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.wire.SerializationWireFormat;
import org.mule.transport.AbstractConnector;

public class RemoteDispatcher
implements Disposable {
    protected static final Log logger = LogFactory.getLog(RemoteDispatcher.class);
    private ImmutableEndpoint asyncServerEndpoint;
    private ImmutableEndpoint syncServerEndpoint;
    private Credentials credentials = null;
    private Executor asyncExecutor;
    private WireFormat wireFormat;

    protected RemoteDispatcher(String endpoint, Credentials credentials) throws MuleException {
        this(endpoint);
        this.credentials = credentials;
    }

    protected RemoteDispatcher(String endpoint) throws MuleException {
        EndpointFactory endpointFactory = RegistryContext.getRegistry().lookupEndpointFactory();
        this.asyncServerEndpoint = endpointFactory.getOutboundEndpoint(endpoint);
        EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpoint);
        endpointBuilder.setRemoteSync(true);
        this.syncServerEndpoint = RegistryContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder);
        this.wireFormat = new SerializationWireFormat();
    }

    protected void setExecutor(Executor e) {
        this.asyncExecutor = e;
    }

    public void dispatchToRemoteComponent(String component, Object payload, Map messageProperties) throws MuleException {
        this.doToRemoteComponent(component, payload, messageProperties, false);
    }

    public MuleMessage sendToRemoteComponent(String component, Object payload, Map messageProperties) throws MuleException {
        return this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public FutureMessageResult sendAsyncToRemoteComponent(final String component, String transformers, final Object payload, final Map messageProperties) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemoteComponent(component, payload, messageProperties, true);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        if (transformers != null) {
            result.setTransformers(TransformerUtils.getTransformers((String)transformers));
        }
        result.execute();
        return result;
    }

    public MuleMessage sendRemote(String endpoint, Object payload, Map messageProperties, int timeout) throws MuleException {
        return this.doToRemote(endpoint, payload, messageProperties, true, timeout);
    }

    public MuleMessage sendRemote(String endpoint, Object payload, Map messageProperties) throws MuleException {
        return this.doToRemote(endpoint, payload, messageProperties, true, RegistryContext.getConfiguration().getDefaultSynchronousEventTimeout());
    }

    public void dispatchRemote(String endpoint, Object payload, Map messageProperties) throws MuleException {
        this.doToRemote(endpoint, payload, messageProperties, false, -1);
    }

    public FutureMessageResult sendAsyncRemote(final String endpoint, final Object payload, final Map messageProperties) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemote(endpoint, payload, messageProperties, true, -1);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        result.execute();
        return result;
    }

    public MuleMessage receiveRemote(String endpoint, int timeout) throws MuleException {
        AdminNotification action = new AdminNotification(null, 601, endpoint);
        action.setProperty((Object)"MULE_REMOTE_SYNC", (Object)"true");
        action.setProperty((Object)"MULE_EVENT_TIMEOUT", (Object)new Long(timeout));
        MuleMessage result = this.dispatchAction(action, true, timeout);
        return result;
    }

    public FutureMessageResult asyncReceiveRemote(final String endpoint, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.receiveRemote(endpoint, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        result.execute();
        return result;
    }

    protected MuleMessage doToRemoteComponent(String component, Object payload, Map messageProperties, boolean synchronous) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties);
        message.setBooleanProperty("MULE_REMOTE_SYNC", synchronous);
        this.setCredentials((MuleMessage)message);
        AdminNotification action = new AdminNotification((MuleMessage)message, 604, "mule://" + component);
        MuleMessage result = this.dispatchAction(action, synchronous, RegistryContext.getConfiguration().getDefaultSynchronousEventTimeout());
        return result;
    }

    protected MuleMessage doToRemote(String endpoint, Object payload, Map messageProperties, boolean synchronous, int timeout) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties);
        message.setProperty("MULE_REMOTE_SYNC", (Object)String.valueOf(synchronous));
        this.setCredentials((MuleMessage)message);
        AdminNotification action = new AdminNotification((MuleMessage)message, synchronous ? 603 : 602, endpoint);
        MuleMessage result = this.dispatchAction(action, synchronous, timeout);
        return result;
    }

    protected MuleMessage dispatchAction(AdminNotification action, boolean synchronous, int timeout) throws MuleException {
        MuleMessage result;
        ImmutableEndpoint serverEndpoint = null;
        serverEndpoint = synchronous ? this.syncServerEndpoint : this.asyncServerEndpoint;
        this.updateContext((MuleMessage)new DefaultMuleMessage((Object)action), serverEndpoint, synchronous);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.wireFormat.write((OutputStream)out, (Object)action, serverEndpoint.getEncoding());
        byte[] payload = out.toByteArray();
        MuleMessage message = action.getMessage();
        message = message == null ? new DefaultMuleMessage((Object)payload) : new DefaultMuleMessage((Object)payload, (MessageAdapter)message);
        message.addProperties(action.getProperties());
        DefaultMuleSession session = new DefaultMuleSession(message, ((AbstractConnector)serverEndpoint.getConnector()).getSessionHandler());
        DefaultMuleEvent event = new DefaultMuleEvent(message, serverEndpoint, (MuleSession)session, true);
        event.setTimeout(timeout);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient sending remote call to: " + action.getResourceIdentifier() + ". At " + serverEndpoint.toString() + " . MuleEvent is: " + event));
        }
        try {
            if (!synchronous) {
                serverEndpoint.dispatch((MuleEvent)event);
                return null;
            }
            result = serverEndpoint.send((MuleEvent)event);
            if (result != null && result.getPayload() != null) {
                Object response;
                if (result.getPayload() instanceof InputStream) {
                    response = this.wireFormat.read((InputStream)result.getPayload());
                } else {
                    ByteArrayInputStream in = new ByteArrayInputStream(result.getPayloadAsBytes());
                    response = this.wireFormat.read((InputStream)in);
                }
                if (response instanceof AdminNotification) {
                    response = ((AdminNotification)response).getMessage();
                }
                return (MuleMessage)response;
            }
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient remote call is: " + (result == null ? "null" : result.getPayload())));
        }
        return result;
    }

    public void dispose() {
    }

    protected void setCredentials(MuleMessage message) {
        if (this.credentials != null) {
            message.setProperty("MULE_USER", (Object)MuleCredentials.createHeader((String)this.credentials.getUsername(), (char[])this.credentials.getPassword()));
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected void updateContext(MuleMessage message, ImmutableEndpoint endpoint, boolean synchronous) throws MuleException {
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent(message, endpoint, (MuleSession)new DefaultMuleSession(message, (SessionHandler)new MuleSessionHandler()), synchronous));
    }
}

