/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.util.StringUtils;

public class MuleXmlBuilderContextListener
implements ServletContextListener {
    public static final String INIT_PARAMETER_MULE_CONFIG = "org.mule.config";
    public static final String INIT_PARAMETER_WEBAPP_CLASSPATH = "org.mule.webapp.classpath";
    private UMOManagementContext managementContext;
    protected final transient Log logger = LogFactory.getLog((Class)MuleXmlBuilderContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        String config = context.getInitParameter(INIT_PARAMETER_MULE_CONFIG);
        if (config == null) {
            config = this.getDefaultConfigResource();
            System.out.println("No Mule config file(s) specified, using default: " + config);
        } else {
            System.out.println("Mule config file(s): " + config);
        }
        String webappClasspath = context.getInitParameter(INIT_PARAMETER_WEBAPP_CLASSPATH);
        if (StringUtils.isBlank((String)webappClasspath)) {
            webappClasspath = null;
        }
        try {
            this.createManager(config, webappClasspath, context);
        }
        catch (UMOException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    protected UMOManagementContext createManager(String configResource, String webappClasspath, ServletContext context) throws ConfigurationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context, webappClasspath);
        this.managementContext = builder.configure(configResource);
        return this.managementContext;
    }

    protected String getDefaultConfigResource() {
        return "mule-config.xml";
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroy();
    }

    public void destroy() {
        if (!(this.managementContext == null || this.managementContext.isDisposing() && this.managementContext.isDisposed())) {
            this.managementContext.dispose();
        }
    }
}

