/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ReaderResource;
import org.mule.config.ThreadingProfile;
import org.mule.config.builders.AbstractDigesterConfiguration;
import org.mule.config.builders.ContainerReference;
import org.mule.config.builders.EndpointReference;
import org.mule.config.builders.MuleSetPropertiesRule;
import org.mule.config.builders.ObjectGetOrCreateRule;
import org.mule.config.builders.PlaceholderProcessor;
import org.mule.config.builders.TransformerReference;
import org.mule.config.converters.ConnectorConverter;
import org.mule.config.converters.EndpointConverter;
import org.mule.config.converters.EndpointURIConverter;
import org.mule.config.converters.TransactionFactoryConverter;
import org.mule.config.converters.TransformerConverter;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.pool.CommonsPoolFactory;
import org.mule.impl.DefaultLifecycleAdapter;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.model.resolvers.DynamicEntryPointResolver;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.interceptors.InterceptorStack;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectionStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.inbound.InboundRouterCollection;
import org.mule.routing.nested.NestedRouter;
import org.mule.routing.nested.NestedRouterCollection;
import org.mule.routing.outbound.OutboundRouterCollection;
import org.mule.routing.response.ResponseRouterCollection;
import org.mule.transaction.constraints.BatchConstraint;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouterCollection;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ArrayUtils;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.EventFilePersistenceStrategy;
import org.xml.sax.Attributes;

public class MuleXmlConfigurationBuilder
extends AbstractDigesterConfiguration
implements ConfigurationBuilder {
    public static final String DEFAULT_ENTRY_POINT_RESOLVER = DynamicEntryPointResolver.class.getName();
    public static final String DEFAULT_LIFECYCLE_ADAPTER = DefaultLifecycleAdapter.class.getName();
    public static final String DEFAULT_ENDPOINT = MuleEndpoint.class.getName();
    public static final String DEFAULT_TRANSACTION_CONFIG = MuleTransactionConfig.class.getName();
    public static final String DEFAULT_DESCRIPTOR = MuleDescriptor.class.getName();
    public static final String DEFAULT_SECURITY_MANAGER = MuleSecurityManager.class.getName();
    public static final String DEFAULT_OUTBOUND_ROUTER_COLLECTION = OutboundRouterCollection.class.getName();
    public static final String DEFAULT_INBOUND_ROUTER_COLLECTION = InboundRouterCollection.class.getName();
    public static final String DEFAULT_NESTED_ROUTER_COLLECTION = NestedRouterCollection.class.getName();
    public static final String DEFAULT_RESPONSE_ROUTER_COLLECTION = ResponseRouterCollection.class.getName();
    public static final String DEFAULT_NESTED_ROUTER = NestedRouter.class.getName();
    public static final String DEFAULT_CATCH_ALL_STRATEGY = LoggingCatchAllStrategy.class.getName();
    public static final String DEFAULT_POOL_FACTORY = CommonsPoolFactory.class.getName();
    public static final String THREADING_PROFILE = ThreadingProfile.class.getName();
    public static final String POOLING_PROFILE = PoolingProfile.class.getName();
    public static final String QUEUE_PROFILE = QueueProfile.class.getName();
    public static final String PERSISTENCE_STRATEGY_INTERFACE = EventFilePersistenceStrategy.class.getName();
    public static final String INBOUND_MESSAGE_ROUTER_INTERFACE = UMOInboundRouterCollection.class.getName();
    public static final String NESTED_MESSAGE_ROUTER_INTERFACE = UMONestedRouterCollection.class.getName();
    public static final String RESPONSE_MESSAGE_ROUTER_INTERFACE = UMOResponseRouterCollection.class.getName();
    public static final String OUTBOUND_MESSAGE_ROUTER_INTERFACE = UMOOutboundRouterCollection.class.getName();
    public static final String TRANSFORMER_INTERFACE = UMOTransformer.class.getName();
    public static final String TRANSACTION_MANAGER_FACTORY_INTERFACE = UMOTransactionManagerFactory.class.getName();
    public static final String SECURITY_PROVIDER_INTERFACE = UMOSecurityProvider.class.getName();
    public static final String ENCRYPTION_STRATEGY_INTERFACE = UMOEncryptionStrategy.class.getName();
    public static final String ENDPOINT_SECURITY_FILTER_INTERFACE = UMOEndpointSecurityFilter.class.getName();
    public static final String AGENT_INTERFACE = UMOAgent.class.getName();
    public static final String TRANSACTION_FACTORY_INTERFACE = UMOTransactionFactory.class.getName();
    public static final String TRANSACTION_CONSTRAINT_INTERFACE = BatchConstraint.class.getName();
    public static final String CONNECTOR_INTERFACE = UMOConnector.class.getName();
    public static final String INTERCEPTOR_INTERFACE = UMOInterceptor.class.getName();
    public static final String ROUTER_INTERFACE = UMOOutboundRouter.class.getName();
    public static final String EXCEPTION_STRATEGY_INTERFACE = ExceptionListener.class.getName();
    public static final String CONNECTION_STRATEGY_INTERFACE = ConnectionStrategy.class.getName();
    protected UMOManager manager;
    private final List transformerReferences = new ArrayList();
    private final List endpointReferences = new ArrayList();

    public MuleXmlConfigurationBuilder() throws ConfigurationException {
        super(System.getProperty("org.mule.xml.validate", "true").equalsIgnoreCase("true"), System.getProperty("org.mule.xml.dtd", "mule-configuration.dtd"));
        ConvertUtils.register((Converter)new EndpointConverter(), (Class)UMOEndpoint.class);
        ConvertUtils.register((Converter)new TransformerConverter(), (Class)UMOTransformer.class);
        ConvertUtils.register((Converter)new ConnectorConverter(), (Class)UMOConnector.class);
        ConvertUtils.register((Converter)new TransactionFactoryConverter(), (Class)UMOTransactionFactory.class);
        ConvertUtils.register((Converter)new EndpointURIConverter(), (Class)UMOEndpointURI.class);
        String path = this.getRootName();
        this.addManagerRules(this.digester, path);
        this.addServerPropertiesRules(path + "/environment-properties", "addProperties", 0);
        this.addContainerContextRules(path + "/container-context", "setContainerContext", 0);
        this.addMuleConfigurationRules(this.digester, path);
        this.addTransformerRules(this.digester, path);
        this.addSecurityManagerRules(this.digester, path);
        this.addTransactionManagerRules(this.digester, path);
        this.addGlobalEndpointRules(this.digester, path);
        this.addEndpointIdentifierRules(this.digester, path);
        this.addInterceptorStackRules(this.digester, path);
        this.addConnectorRules(this.digester, path);
        this.addAgentRules(this.digester, path);
        this.addModelRules(this.digester, path);
    }

    public String getRootName() {
        return "mule-configuration";
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            String[] resources = StringUtils.splitAndTrim((String)configResources, (String)",");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("There is/are " + resources.length + " configuration resource(s): " + ArrayUtils.toString((Object)resources)));
            }
            MuleManager.getConfiguration().setConfigResources(resources);
            ReaderResource[] readers = new ReaderResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                String resource = resources[i];
                readers[i] = new ReaderResource(resource, (Reader)new InputStreamReader(this.loadResource(resource), this.configEncoding));
            }
            if (startupPropertiesFile != null) {
                return this.configure(readers, PropertiesUtils.loadProperties((String)startupPropertiesFile, this.getClass()));
            }
            return this.configure(readers, null);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected InputStream loadResource(String configResource) throws ConfigurationException {
        try {
            InputStream input = IOUtils.getResourceAsStream((String)configResource, this.getClass());
            if (input == null) {
                throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)configResource));
            }
            return input;
        }
        catch (IOException e) {
            throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)configResource), (Throwable)e);
        }
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        if (startupProperties != null) {
            ((MuleManager)MuleManager.getInstance()).addProperties((Map)startupProperties);
        }
        this.manager = (MuleManager)this.process(configResources);
        if (this.manager == null) {
            throw new ConfigurationException(CoreMessages.failedToCreateManagerInstance((String)"Are you using a correct configuration builder?"));
        }
        try {
            this.setContainerProperties();
            this.setTransformers();
            this.setGlobalEndpoints();
            if (System.getProperty("org.mule.start.after.config", "true").equalsIgnoreCase("true")) {
                this.manager.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(CoreMessages.objectFailedToInitialise((String)"MuleManager"), (Throwable)e);
        }
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainerProperties() throws ContainerException {
        UMOContainerContext ctx = this.manager.getContainerContext();
        try {
            Iterator iterator = this.containerReferences.iterator();
            while (iterator.hasNext()) {
                ContainerReference reference = (ContainerReference)iterator.next();
                reference.resolveReference(ctx);
            }
        }
        finally {
            this.containerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransformers() throws InitialisationException {
        try {
            Iterator iterator = this.transformerReferences.iterator();
            while (iterator.hasNext()) {
                TransformerReference reference = (TransformerReference)iterator.next();
                reference.resolveTransformer();
            }
        }
        finally {
            this.transformerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalEndpoints() throws InitialisationException {
        UMOManager manager = MuleManager.getInstance();
        HashMap endpoints = new HashMap(manager.getEndpoints());
        Iterator<Object> iterator = endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            manager.unregisterEndpoint(ep.getName());
            manager.registerEndpoint(ep);
        }
        try {
            iterator = this.endpointReferences.iterator();
            while (iterator.hasNext()) {
                EndpointReference reference = (EndpointReference)iterator.next();
                reference.resolveEndpoint();
            }
        }
        finally {
            this.endpointReferences.clear();
        }
    }

    protected void addManagerRules(Digester digester, String path) {
        digester.addFactoryCreate(path, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                MuleXmlConfigurationBuilder.this.manager = MuleManager.getInstance();
                return MuleXmlConfigurationBuilder.this.manager;
            }
        });
        digester.addSetProperties(path);
    }

    protected void addMuleConfigurationRules(Digester digester, String path) {
        digester.addSetProperties(path);
        path = path + "/mule-environment-properties";
        digester.addObjectCreate(path, MuleConfiguration.class);
        this.addSetPropertiesRule(path, digester);
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addObjectCreate(path + "/threading-profile", THREADING_PROFILE);
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("poolExhaustedAction", "poolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.id = attributes.getValue("id");
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.peek();
                MuleConfiguration cfg = (MuleConfiguration)this.digester.peek(1);
                if ("default".equals(this.id)) {
                    cfg.setDefaultThreadingProfile(tp);
                    cfg.setMessageDispatcherThreadingProfile(tp);
                    cfg.setMessageReceiverThreadingProfile(tp);
                    cfg.setComponentThreadingProfile(tp);
                } else if ("messageReceiver".equals(this.id) || "receiver".equals(this.id)) {
                    cfg.setMessageReceiverThreadingProfile(tp);
                } else if ("messageDispatcher".equals(this.id) || "dispatcher".equals(this.id)) {
                    cfg.setMessageDispatcherThreadingProfile(tp);
                } else if ("component".equals(this.id)) {
                    cfg.setComponentThreadingProfile(tp);
                }
            }
        });
        digester.addObjectCreate(path + "/persistence-strategy", PERSISTENCE_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/persistence-strategy", digester);
        digester.addSetNext(path + "/persistence-strategy", "setPersistenceStrategy");
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addRule(path + "/connection-strategy", (Rule)new SetNextRule("setConnectionStrategy"){

            public void end(String s, String s1) throws Exception {
                super.end(s, s1);
            }
        });
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                MuleManager.setConfiguration((MuleConfiguration)((MuleConfiguration)this.digester.peek()));
            }
        });
    }

    protected void addSecurityManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/security-manager";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_SECURITY_MANAGER, "className", "ref", false);
        digester.addObjectCreate(path + "/security-provider", SECURITY_PROVIDER_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/security-provider", digester);
        this.addMulePropertiesRule(path + "/security-provider", digester);
        digester.addSetNext(path + "/security-provider", "addProvider");
        digester.addObjectCreate(path + "/encryption-strategy", ENCRYPTION_STRATEGY_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/encryption-strategy", digester);
        this.addMulePropertiesRule(path + "/encryption-strategy", digester);
        digester.addRule(path + "/encryption-strategy", new Rule(){
            private String name;

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                this.name = attributes.getValue("name");
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                UMOEncryptionStrategy s = (UMOEncryptionStrategy)this.digester.peek();
                ((UMOSecurityManager)this.digester.peek(1)).addEncryptionStrategy(this.name, s);
            }
        });
        digester.addSetNext(path, "setSecurityManager");
    }

    protected void addTransformerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transformers/transformer";
        this.addObjectCreateOrGetFromContainer(path, TRANSFORMER_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerTransformer");
    }

    protected void addGlobalEndpointRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/global-endpoints";
        this.addEndpointRules(digester, path, "registerEndpoint");
    }

    protected void addEndpointIdentifierRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/endpoint-identifiers/endpoint-identifier";
        digester.addRule(path, new Rule(){
            private PlaceholderProcessor processor = new PlaceholderProcessor();

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = this.processor.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                ((UMOManager)this.digester.getRoot()).registerEndpointIdentifier(name, value);
            }
        });
    }

    protected void addTransactionManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transaction-manager";
        this.addObjectCreateOrGetFromContainer(path, TRANSACTION_MANAGER_FACTORY_INTERFACE, "factory", "ref", true);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "setTransactionManager");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMOTransactionManagerFactory txFactory = (UMOTransactionManagerFactory)this.digester.pop();
                this.digester.push((Object)txFactory.create());
            }
        });
    }

    protected void addAgentRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/agents/agent";
        this.addObjectCreateOrGetFromContainer(path, AGENT_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerAgent");
    }

    protected void addConnectorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/connector";
        this.addObjectCreateOrGetFromContainer(path, CONNECTOR_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.id = attributes.getValue("id");
                if ("default".equals(this.id)) {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                } else if ("receiver".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageReceiverThreadingProfile());
                } else if ("dispatcher".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageDispatcherThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.pop();
                AbstractConnector cnn = (AbstractConnector)this.digester.peek();
                if ("default".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                    cnn.setDispatcherThreadingProfile(tp);
                } else if ("receiver".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                } else if ("dispatcher".equals(this.id)) {
                    cnn.setDispatcherThreadingProfile(tp);
                }
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addSetNext(path + "/connection-strategy", "setConnectionStrategy");
        this.addExceptionStrategyRules(digester, path);
        digester.addSetRoot(path, "registerConnector");
    }

    protected void addInterceptorStackRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/interceptor-stack";
        digester.addRule(path + "/interceptor", (Rule)new ObjectCreateRule(INTERCEPTOR_INTERFACE, "className"){

            public void end(String s, String s1) throws Exception {
            }
        });
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.digester.push((Object)attributes.getValue("name"));
            }

            public void end(String s, String s1) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                Object obj = this.digester.peek();
                while (obj instanceof UMOInterceptor) {
                    list.add(0, this.digester.pop());
                    obj = this.digester.peek();
                }
                InterceptorStack stack = new InterceptorStack();
                stack.setInterceptors(list);
                MuleXmlConfigurationBuilder.this.manager.registerInterceptorStack(this.digester.pop().toString(), (UMOInterceptorStack)stack);
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester);
    }

    protected void addModelRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/model";
        digester.addRule(path, new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                UMOModel model;
                String modelType = attributes.getValue("type");
                String modelName = attributes.getValue("name");
                if (modelType == null) {
                    modelType = MuleManager.getConfiguration().getModelType();
                }
                if (modelType.equalsIgnoreCase("custom")) {
                    String className = attributes.getValue("className");
                    if (className == null) {
                        throw new IllegalArgumentException("Cannot use 'custom' model type without setting the 'className' for the model");
                    }
                    model = (UMOModel)ClassUtils.instanciateClass((String)className, (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                } else if (modelType.equalsIgnoreCase("inherited")) {
                    Map models = MuleManager.getInstance().getModels();
                    if (models.size() == 0) {
                        throw new IllegalArgumentException("When using model inheritance there must be one model registered with Mule");
                    }
                    model = (UMOModel)models.get(modelName);
                    if (model == null) {
                        throw new IllegalArgumentException("Cannot inherit from model '" + modelName + "'. No such model registered");
                    }
                } else {
                    model = ModelFactory.createModel((String)modelType);
                }
                this.digester.push((Object)model);
            }
        });
        this.addSetPropertiesRule(path, digester);
        digester.addSetRoot(path, "registerModel");
        digester.addObjectCreate(path + "/entry-point-resolver", DEFAULT_ENTRY_POINT_RESOLVER, "className");
        this.addSetPropertiesRule(path + "/entry-point-resolver", digester);
        digester.addSetNext(path + "/entry-point-resolver", "setEntryPointResolver");
        digester.addObjectCreate(path + "/component-lifecycle-adapter-factory", DEFAULT_LIFECYCLE_ADAPTER, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path + "/component-lifecycle-adapter-factory", "setLifecycleAdapterFactory");
        this.addPoolingProfileRules(digester, path);
        this.addExceptionStrategyRules(digester, path);
        this.addMuleDescriptorRules(digester, path);
    }

    protected void addMuleDescriptorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/mule-descriptor";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_DESCRIPTOR, "className", "ref", "container", false);
        this.addSetPropertiesRule(path, digester);
        this.addMessageRouterRules(digester, path, "inbound");
        this.addMessageRouterRules(digester, path, "outbound");
        this.addMessageRouterRules(digester, path, "nested");
        this.addMessageRouterRules(digester, path, "response");
        this.addThreadingProfileRules(digester, path, "component");
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addRule(path + "/interceptor", new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                String value = attributes.getValue("name");
                if (value == null) {
                    value = attributes.getValue("className");
                }
                UMOManager man = (UMOManager)this.digester.getRoot();
                UMOInterceptorStack interceptorStack = man.lookupInterceptorStack(value);
                MuleDescriptor temp = (MuleDescriptor)this.digester.peek();
                if (interceptorStack != null) {
                    temp.addInterceptor((UMOInterceptor)interceptorStack);
                } else {
                    Class<?> clazz = this.digester.getClassLoader().loadClass(value);
                    Object instance = clazz.newInstance();
                    temp.addInterceptor((UMOInterceptor)instance);
                    this.digester.push(instance);
                }
            }

            public void end(String s, String s1) throws Exception {
                if (this.digester.peek() instanceof UMOInterceptor) {
                    this.digester.pop();
                }
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester);
        this.addExceptionStrategyRules(digester, path);
        this.addMulePropertiesRule(path, digester, "setProperties");
        digester.addSetNext(path + "/properties", "setProperties");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMODescriptor descriptor = (UMODescriptor)this.digester.peek();
                Object obj = this.digester.peek(1);
                UMOModel model = (UMOModel)obj;
                descriptor.setModelName(model.getName());
                model.registerComponent(descriptor);
            }
        });
    }

    protected void addThreadingProfileRules(Digester digester, String path, final String type) {
        digester.addRule(path + "/threading-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                if ("component".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageReceiver".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageDispatcher".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addSetNext(path + "/threading-profile", "setThreadingProfile");
    }

    protected void addPoolingProfileRules(Digester digester, String path) {
        digester.addRule(path + "/pooling-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.digester.push((Object)cfg.getPoolingProfile());
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule rule = new SetPropertiesRule();
        rule.addAlias("exhaustedAction", "exhaustedActionString");
        rule.addAlias("initialisationPolicy", "initialisationPolicyString");
        digester.addRule(path + "/pooling-profile", (Rule)rule);
        digester.addSetNext(path + "/pooling-profile", "setPoolingProfile");
    }

    protected void addQueueProfileRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/queue-profile", QUEUE_PROFILE);
        this.addSetPropertiesRule(path + "/queue-profile", digester);
        digester.addSetNext(path + "/queue-profile", "setQueueProfile");
    }

    protected void addMessageRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        String setMethod;
        String defaultRouter;
        if ("inbound".equals(type)) {
            defaultRouter = DEFAULT_INBOUND_ROUTER_COLLECTION;
            setMethod = "setInboundRouter";
            path = path + "/inbound-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else if ("response".equals(type)) {
            defaultRouter = DEFAULT_RESPONSE_ROUTER_COLLECTION;
            setMethod = "setResponseRouter";
            path = path + "/response-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else if ("nested".equals(type)) {
            defaultRouter = DEFAULT_NESTED_ROUTER_COLLECTION;
            setMethod = "setNestedRouter";
            path = path + "/nested-router";
        } else {
            defaultRouter = DEFAULT_OUTBOUND_ROUTER_COLLECTION;
            setMethod = "setOutboundRouter";
            path = path + "/outbound-router";
        }
        digester.addObjectCreate(path, defaultRouter, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addObjectCreate(path + "/catch-all-strategy", DEFAULT_CATCH_ALL_STRATEGY, "className");
        this.addSetPropertiesRule(path + "/catch-all-strategy", digester);
        this.addEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addMulePropertiesRule(path + "/catch-all-strategy", digester);
        digester.addSetNext(path + "/catch-all-strategy", "setCatchAllStrategy");
        this.addRouterRules(digester, path, type);
        digester.addSetNext(path, setMethod);
    }

    protected void addRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        if ("nested".equals(type)) {
            path = path + "/binding";
            digester.addObjectCreate(path, DEFAULT_NESTED_ROUTER);
        } else if ("inbound".equals(type)) {
            path = path + "/router";
            digester.addObjectCreate(path, INBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        } else if ("response".equals(type)) {
            path = path + "/router";
            digester.addObjectCreate(path, RESPONSE_MESSAGE_ROUTER_INTERFACE, "className");
        } else {
            path = path + "/router";
            digester.addObjectCreate(path, OUTBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        }
        this.addSetPropertiesRule(path, digester, new String[]{"enableCorrelation", "propertyExtractor"}, new String[]{"enableCorrelationAsString", "propertyExtractorAsString"});
        this.addMulePropertiesRule(path, digester);
        if ("outbound".equals(type)) {
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addReplyToRules(digester, path);
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
            this.addTransactionConfigRules(path, digester);
        } else if ("nested".equals(type)) {
            this.addEndpointRules(digester, path, "setEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "setEndpoint");
        }
        this.addFilterRules(digester, path);
        digester.addSetNext(path, "addRouter");
    }

    protected void addReplyToRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/reply-to";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String replyTo = attributes.getValue("address");
                ((UMOOutboundRouter)this.digester.peek()).setReplyTo(replyTo);
            }
        });
    }

    protected void addEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        path = path + "/endpoint";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_ENDPOINT, "className", "ref", false);
        this.addCommonEndpointRules(digester, path, method);
    }

    protected void addGlobalReferenceEndpointRules(Digester digester, String path, final String method) throws ConfigurationException {
        path = path + "/global-endpoint";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String name = attributes.getValue("name");
                String address = attributes.getValue("address");
                String trans = attributes.getValue("transformers");
                String responseTrans = attributes.getValue("responseTransformers");
                String createConnector = attributes.getValue("createConnector");
                EndpointReference ref = new EndpointReference(method, name, address, trans, responseTrans, createConnector, this.digester.peek());
                this.digester.push((Object)ref);
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                MuleXmlConfigurationBuilder.this.endpointReferences.add(this.digester.pop());
            }
        });
        this.addCommonEndpointRules(digester, path, null);
    }

    protected void addCommonEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        this.addSetPropertiesRule(path, digester, new String[]{"address", "transformers", "responseTransformers", "createConnector"}, new String[]{"endpointURI", "transformer", "responseTransformer", "createConnectorAsString"});
        this.addMulePropertiesRule(path, digester, "setProperties");
        this.addTransactionConfigRules(path, digester);
        this.addFilterRules(digester, path);
        if (method != null) {
            digester.addSetNext(path, method);
        }
        digester.addObjectCreate(path + "/security-filter", ENDPOINT_SECURITY_FILTER_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/security-filter", digester);
        digester.addSetNext(path + "/security-filter", "setSecurityFilter");
    }

    protected void addTransactionConfigRules(String path, Digester digester) {
        digester.addObjectCreate(path + "/transaction", DEFAULT_TRANSACTION_CONFIG);
        this.addSetPropertiesRule(path + "/transaction", digester, new String[]{"action"}, new String[]{"actionAsString"});
        digester.addObjectCreate(path + "/transaction/constraint", TRANSACTION_CONSTRAINT_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/transaction/constraint", digester);
        digester.addSetNext(path + "/transaction/constraint", "setConstraint");
        digester.addSetNext(path + "/transaction", "setTransactionConfig");
    }

    protected void addExceptionStrategyRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/exception-strategy";
        digester.addObjectCreate(path, EXCEPTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path, digester);
        this.addEndpointRules(digester, path, "addEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        digester.addSetNext(path, "setExceptionListener");
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule(s1, s2));
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule());
    }

    private void addTransformerReference(String propName, String transName, Object object) {
        this.transformerReferences.add(new TransformerReference(propName, transName, object));
    }

    private void addEndpointReference(String propName, String endpointName, Object object) {
        this.endpointReferences.add(new EndpointReference(propName, endpointName, null, null, null, null, object));
    }

    protected void addObjectCreateOrGetFromContainer(String path, String defaultImpl, String classAttrib, String refAttrib, boolean classRefRequired) {
        this.digester.addRule(path, (Rule)new ObjectGetOrCreateRule(defaultImpl, classAttrib, refAttrib, classAttrib, classRefRequired, "getContainerContext"));
    }

    protected void addObjectCreateOrGetFromContainer(String path, String defaultImpl, String classAttrib, String refAttrib, String containerAttrib, boolean classRefRequired) {
        this.digester.addRule(path, (Rule)new ObjectGetOrCreateRule(defaultImpl, classAttrib, refAttrib, containerAttrib, classAttrib, classRefRequired, "getContainerContext"));
    }

    public class ExtendedMuleSetPropertiesRule
    extends MuleSetPropertiesRule {
        public ExtendedMuleSetPropertiesRule() {
        }

        public ExtendedMuleSetPropertiesRule(PlaceholderProcessor processor) {
            super(processor);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1) {
            super(strings, strings1);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1, PlaceholderProcessor processor) {
            super(strings, strings1, processor);
        }

        public void begin(String s1, String s2, Attributes attributes) throws Exception {
            Object o;
            String endpoint;
            String transformerNames = (attributes = this.processor.processAttributes(attributes, s2)).getValue("transformer");
            if (transformerNames != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("transformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("inboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("inboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("outboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("outboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("inboundEndpoint")) != null && (o = MuleXmlConfigurationBuilder.this.manager.getEndpoints().get(endpoint)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setInboundEndpoint", endpoint, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("outboundEndpoint")) != null && (o = MuleXmlConfigurationBuilder.this.manager.getEndpoints().get(endpoint)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setOutboundEndpoint", endpoint, this.digester.peek());
            }
            super.begin(attributes);
        }
    }
}

