/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.Message;
import org.mule.impl.security.PasswordBasedEncryptionStrategy;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.TemplateParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PlaceholderProcessor {
    public static final String MULE_ENCRYPTION_PROPERTIES = "org.mule.config.encryption.properties";
    public static final String DEFAULT_ENCRYPTION_PROPERTIES_FILE = "mule-encryption.properties";
    protected static transient Log logger = LogFactory.getLog((Class)PlaceholderProcessor.class);
    private static boolean strategiesLoaded = false;
    private Map types = new HashMap();
    private Map schemes = new HashMap();
    private TemplateParser parser = TemplateParser.createAntStyleParser();

    public PlaceholderProcessor() {
        this.types.put("PBE", PasswordBasedEncryptionStrategy.class.getName());
    }

    public PlaceholderProcessor(Map types) {
        this.types = types;
    }

    public Attributes processAttributes(Attributes attributes, String elementName) throws ConfigurationException {
        AttributesImpl attribs = new AttributesImpl(attributes);
        String value = null;
        for (int i = 0; i < attribs.getLength(); ++i) {
            value = attribs.getValue(i);
            if ((value = this.processValue(value)) == null) {
                throw new ConfigurationException(new Message(158, (Object)("<" + elementName + attribs.getLocalName(i) + "='" + value + "' ...>")));
            }
            attribs.setValue(i, value);
        }
        return attribs;
    }

    public String processValue(String value) throws ConfigurationException {
        return this.parser.parse(MuleManager.getInstance().getProperties(), value);
    }

    protected String processEncryptedValue(String value) throws ConfigurationException {
        int x = value.indexOf("{encrypt:");
        if (x > -1) {
            logger.debug((Object)"Value contains encrypted data.");
            int y = value.indexOf("}");
            if (y == -1) {
                logger.error((Object)("Encryption tag is malformed: " + value));
                return null;
            }
            String scheme = value.substring(x + 9, y);
            logger.debug((Object)("look up encryption scheme: " + scheme));
            try {
                UMOEncryptionStrategy strategy = this.getEncryptionStrategy(scheme);
                String data = value.substring(y + 1);
                byte[] decrypted = strategy.decrypt(data.getBytes(), null);
                return new String(decrypted);
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        return value;
    }

    public UMOEncryptionStrategy getEncryptionStrategy(String scheme) throws Exception {
        if (!strategiesLoaded) {
            this.loadStrategies();
        }
        return (UMOEncryptionStrategy)this.schemes.get(scheme);
    }

    private void loadStrategies() throws Exception {
        String path = System.getProperty(MULE_ENCRYPTION_PROPERTIES, MuleManager.getConfiguration().getWorkingDirectory() + File.separator + DEFAULT_ENCRYPTION_PROPERTIES_FILE);
        logger.info((Object)("Attempting to load encryption properties from: " + path));
        Properties props = PropertiesUtils.loadProperties((String)path, this.getClass());
        HashMap names = new HashMap();
        PropertiesUtils.getPropertiesWithPrefix((Map)props, (String)"name", names);
        Iterator iterator = names.values().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Map schemeConfig = new HashMap();
            PropertiesUtils.getPropertiesWithPrefix((Map)props, (String)(name + "."), schemeConfig);
            schemeConfig = PropertiesUtils.removeNamespaces(schemeConfig);
            String type = (String)schemeConfig.get("type");
            String clazz = (String)this.types.get(type);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown encryption type: " + type);
            }
            logger.debug((Object)("Found Class: " + clazz + " for type: " + type));
            UMOEncryptionStrategy strat = (UMOEncryptionStrategy)ClassUtils.instanciateClass((String)clazz, (Object[])ClassUtils.NO_ARGS, (Class)(class$org$mule$config$builders$PlaceholderProcessor == null ? PlaceholderProcessor.class$("org.mule.config.builders.PlaceholderProcessor") : class$org$mule$config$builders$PlaceholderProcessor));
            BeanUtils.populateWithoutFail((Object)strat, schemeConfig, (boolean)true);
            this.schemes.put(name, strat);
        }
    }
}

