/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.module.boot.MuleBootstrapUtils;
import org.mule.module.boot.MuleServerWrapper;
import org.mule.module.boot.VersionWrapper;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public class MuleBootstrap {
    private static final String MULE_MODULE_BOOT_POM_FILE_PATH = "META-INF/maven/org.mule.module/mule-module-boot/pom.properties";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"production", "false", "Modify the system class loader for production use (as in Mule 2.x)"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = MuleBootstrap.parseCommandLine(args);
        String[] remainingArgs = commandLine.getArgs();
        MuleBootstrap.prepareBootstrapPhase(commandLine);
        String mainClassName = commandLine.getOptionValue("main");
        if (commandLine.hasOption("version")) {
            WrapperManager.start((WrapperListener)new VersionWrapper(), (String[])remainingArgs);
        } else if (mainClassName == null || mainClassName.equals(MuleServerWrapper.class.getName())) {
            System.out.println("Starting the Mule Server...");
            WrapperManager.start((WrapperListener)new MuleServerWrapper(), (String[])remainingArgs);
        } else {
            String[] appArgs = new String[remainingArgs.length + 1];
            appArgs[0] = mainClassName;
            System.arraycopy(remainingArgs, 0, appArgs, 1, remainingArgs.length);
            System.out.println("Starting class " + mainClassName + "...");
            WrapperSimpleApp.main((String[])appArgs);
        }
    }

    private static void prepareBootstrapPhase(CommandLine commandLine) throws Exception {
        boolean production = commandLine.hasOption("production");
        MuleBootstrap.prepareBootstrapPhase(production);
    }

    private static void prepareBootstrapPhase(boolean production) throws Exception {
        File muleHome = MuleBootstrap.lookupMuleHome();
        File muleBase = MuleBootstrap.lookupMuleBase();
        if (muleBase == null) {
            muleBase = muleHome;
        }
        if (production) {
            MuleBootstrapUtils.addLocalJarFilesToClasspath(muleHome, muleBase);
        }
        MuleBootstrap.setSystemMuleVersion();
    }

    public static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    public static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSystemMuleVersion() {
        InputStream propertiesStream = null;
        try {
            URL mavenPropertiesUrl = MuleBootstrapUtils.getResource(MULE_MODULE_BOOT_POM_FILE_PATH, MuleServerWrapper.class);
            propertiesStream = mavenPropertiesUrl.openStream();
            Properties mavenProperties = new Properties();
            mavenProperties.load(propertiesStream);
            System.setProperty("mule.version", mavenProperties.getProperty("version"));
            System.setProperty("mule.reference.version", mavenProperties.getProperty("version") + '-' + new Date().getTime());
        }
        catch (Exception exception) {
        }
        finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (int i = 0; i < CLI_OPTIONS.length; ++i) {
            options.addOption(CLI_OPTIONS[i][0], "true".equalsIgnoreCase(CLI_OPTIONS[i][1]), CLI_OPTIONS[i][2]);
        }
        return new BasicParser().parse(options, args, true);
    }
}

