/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.mule.modules.boot.MuleBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;

public class LibraryDownloader {
    private static final int HTTP_CONNECTION_TIMEOUT = 10000;
    private static final String REPO_CENTRAL = "http://repo1.maven.org/maven2";
    private static final String BOOTSTRAP_LIBRARY_DOWNLOAD_DESCRIPTION_PREFIX = "mule.bootstrap.library.download.description.";
    private static final String PROXY_ERROR_MESSAGE = "Unable to reach remote repository. This is most likely because you are behind a firewall and missing proxy settings in Mule.Proxy options can be passed during startup as follows:\n -M-Dhttp.proxyHost=YOUR_HOST\n -M-Dhttp.proxyPort=YOUR_PORT\n -M-Dhttp.proxyUsername=YOUR_USERNAME\n -M-Dhttp.proxyPassword=YOUR_PASSWORD\n";
    private MuleBootstrapUtils.ProxyInfo proxyInfo;
    private HostConfiguration hostConfig;
    private HttpState httpState;
    private File muleHome;
    private File mavenRepo = null;
    private HttpClient client;
    private List libraryDownloadDescriptions = new ArrayList();

    public LibraryDownloader(File muleHome) {
        this(muleHome, new MuleBootstrapUtils.ProxyInfo(System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("http.proxyUsername"), System.getProperty("http.proxyPassword")));
    }

    public LibraryDownloader(File muleHome, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
        this(muleHome, new MuleBootstrapUtils.ProxyInfo(proxyHost, proxyPort, proxyUsername, proxyPassword));
    }

    public LibraryDownloader(File muleHome, MuleBootstrapUtils.ProxyInfo proxyInfo) {
        this.muleHome = muleHome;
        this.proxyInfo = proxyInfo;
        this.configureMavenRepository();
        this.configureHttpClient();
        this.configureHttpProxy();
        this.readLibraryDownloadDescriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List downloadLibraries() throws IOException {
        ArrayList<URL> libraryUrls;
        block8: {
            libraryUrls = new ArrayList<URL>();
            Throwable proxyException = null;
            try {
                Iterator iter = this.libraryDownloadDescriptions.iterator();
                while (iter.hasNext()) {
                    URL libraryUrl = this.downloadLibrary((Library)iter.next());
                    if (libraryUrl == null) continue;
                    libraryUrls.add(libraryUrl);
                }
            }
            catch (UnknownHostException uhe) {
                proxyException = uhe;
                return proxyException;
            }
            catch (ConnectTimeoutException cte) {
                proxyException = cte;
                return proxyException;
            }
            finally {
                if (proxyException == null) break block8;
                System.err.println();
                IOException ex = new IOException(PROXY_ERROR_MESSAGE);
                ex.initCause(proxyException);
                throw ex;
            }
        }
        return libraryUrls;
    }

    private void configureMavenRepository() {
        String mavenRepoVar = System.getProperty("m2.repo");
        if (!StringUtils.isBlank((String)mavenRepoVar)) {
            this.mavenRepo = new File(mavenRepoVar).getAbsoluteFile();
            if (!this.mavenRepo.exists() || !this.mavenRepo.isDirectory()) {
                this.mavenRepo = null;
            }
        }
    }

    private void configureHttpClient() {
        this.client = new HttpClient();
        HttpConnectionManagerParams connParams = new HttpConnectionManagerParams();
        connParams.setConnectionTimeout(10000);
        this.client.getHttpConnectionManager().setParams(connParams);
    }

    private void configureHttpProxy() {
        this.hostConfig = new HostConfiguration();
        if (StringUtils.isNotBlank((String)this.proxyInfo.host)) {
            this.hostConfig.setProxy(this.proxyInfo.host, NumberUtils.toInt((String)this.proxyInfo.port));
        }
        this.httpState = new HttpState();
        if (StringUtils.isNotBlank((String)this.proxyInfo.username)) {
            this.httpState.setProxyCredentials(new AuthScope(null, -1, null, null), (Credentials)new UsernamePasswordCredentials(this.proxyInfo.username, this.proxyInfo.password));
        }
    }

    private void readLibraryDownloadDescriptions() {
        Properties properties = System.getProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String[] descriptions;
            String key = (String)keys.nextElement();
            if (!key.startsWith(BOOTSTRAP_LIBRARY_DOWNLOAD_DESCRIPTION_PREFIX) || (descriptions = properties.getProperty(key).split(",")) == null || descriptions.length != 3) continue;
            this.libraryDownloadDescriptions.add(new Library(descriptions[0].trim(), descriptions[1].trim(), descriptions[2].trim()));
        }
    }

    private URL downloadLibrary(Library library) throws IOException {
        URL libraryUrl = null;
        if (!ClassUtils.isClassOnPath((String)library.testClassName, MuleBootstrapUtils.class) && (libraryUrl = this.downloadLibraryFromLocalRepository(library.jarPath, library.jarName)) == null) {
            libraryUrl = this.downloadLibraryFromRemoteRepository(library.jarPath, library.jarName);
        }
        return libraryUrl;
    }

    private URL downloadLibraryFromLocalRepository(String path, String destinationFileName) throws IOException {
        File sourceFile;
        URL libraryUrl = null;
        if (this.mavenRepo != null && (sourceFile = new File(this.mavenRepo, path + File.separator + destinationFileName).getCanonicalFile()).exists()) {
            System.out.print("Copying from local repository " + sourceFile.getAbsolutePath() + " ...");
            File destinationFile = new File(new File(this.muleHome, "/lib/user").getCanonicalFile(), destinationFileName).getCanonicalFile();
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            System.out.println("done");
            libraryUrl = destinationFile.toURL();
        }
        return libraryUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL downloadLibraryFromRemoteRepository(String path, String destinationFileName) throws IOException {
        URL libraryUrl;
        block4: {
            libraryUrl = null;
            GetMethod httpMethod = new GetMethod(REPO_CENTRAL + path + '/' + destinationFileName);
            try {
                System.out.print("Downloading " + httpMethod.getURI() + " ...");
                this.client.executeMethod(this.hostConfig, (HttpMethod)httpMethod, this.httpState);
                if (httpMethod.getStatusCode() == 200) {
                    File destinationFile = new File(new File(this.muleHome, "/lib/user"), destinationFileName);
                    FileUtils.copyStreamToFile((InputStream)httpMethod.getResponseBodyAsStream(), (File)destinationFile);
                    System.out.println("done");
                    libraryUrl = destinationFile.toURL();
                    break block4;
                }
                System.out.println();
                throw new IOException("HTTP request failed: " + httpMethod.getStatusLine().toString());
            }
            finally {
                httpMethod.releaseConnection();
            }
        }
        return libraryUrl;
    }

    private static class Library {
        public String testClassName;
        public String jarPath;
        public String jarName;

        public Library(String testClassName, String jarPath, String jarName) {
            this.testClassName = testClassName;
            this.jarPath = jarPath;
            this.jarName = jarName;
        }
    }
}

