/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mule.MuleServer;
import org.mule.modules.boot.DefaultMuleClassPathConfig;
import org.mule.modules.boot.LibraryDownloader;
import org.mule.modules.boot.LicenseHandler;
import org.mule.modules.boot.ReflectionHelper;

public class MuleBootstrap {
    private MuleBootstrap() {
    }

    public static void main(String[] args) throws Exception {
        LicenseHandler licenseHandler;
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        String muleBaseVar = System.getProperty("mule.base");
        File muleBase = muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%") ? new File(muleBaseVar).getCanonicalFile() : muleHome;
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleBase);
        MuleBootstrap.addLibrariesToClasspath(classPath.getURLs());
        if (ReflectionHelper.getResource("META-INF/mule/license.props", MuleBootstrap.class) == null && !(licenseHandler = new LicenseHandler(muleHome, muleBase)).getAcceptance()) {
            ReflectionHelper.wrapperStop(-1);
        }
        if (!ReflectionHelper.isClassOnPath("javax.activation.DataSource", MuleBootstrap.class)) {
            LibraryDownloader downloader = new LibraryDownloader(muleBase);
            MuleBootstrap.addLibrariesToClasspath(downloader.downloadLibraries());
        }
        String mainClassName = null;
        try {
            String[][] cliOptions = ReflectionHelper.getCliOptions();
            mainClassName = ReflectionHelper.getCommandLineOption("main", args, cliOptions);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            ReflectionHelper.wrapperStop(-1);
        }
        if (mainClassName == null) {
            mainClassName = MuleServer.class.getName();
        }
        String[] appArgs = new String[args.length + 1];
        appArgs[0] = mainClassName;
        System.arraycopy(args, 0, appArgs, 1, args.length);
        ReflectionHelper.wrapperMain(appArgs);
    }

    private static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }
}

