/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mule.modules.boot.DefaultMuleClassPathConfig;
import org.mule.modules.boot.LibraryDownloader;
import org.mule.util.ClassUtils;

public class GuiInstallerLibraryDownloader {
    private static String proxyHost = null;
    private static String proxyPort = null;
    private static String proxyUsername = null;
    private static String proxyPassword = null;

    public static void main(String[] args) throws Exception {
        File muleHome = new File(args[0].toString());
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleHome);
        GuiInstallerLibraryDownloader.addLibrariesToClasspath(classPath.getURLs());
        if (!ClassUtils.isClassOnPath((String)"javax.activation.DataSource", (Class)GuiInstallerLibraryDownloader.class)) {
            if (args.length > 1) {
                proxyHost = args[1].toString();
            }
            if (args.length > 2) {
                proxyPort = args[2].toString();
            }
            if (args.length > 2) {
                proxyUsername = args[3].toString();
            }
            if (args.length > 3) {
                proxyPassword = args[4].toString();
            }
            LibraryDownloader downloader = new LibraryDownloader(muleHome, proxyHost, proxyPort, proxyUsername, proxyPassword);
            GuiInstallerLibraryDownloader.addLibrariesToClasspath(downloader.downloadLibraries());
        }
    }

    private static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }
}

