/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.mule.util.FileUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;
import org.tanukisoftware.wrapper.WrapperManager;

public class LibraryDownloader {
    static final int STARTUP_TIMEOUT = 120000;
    static final String REPO_CENTRAL = "http://www.ibiblio.org/maven2";
    static final String REPO_MULESOURCE = "http://dist.codehaus.org/mule/dependencies/maven2";
    static String proxyHostname = System.getProperty("http.proxyHost");
    static String proxyPort = System.getProperty("http.proxyPort");
    static String proxyUsername = System.getProperty("http.proxyUsername");
    static String proxyPassword = System.getProperty("http.proxyPassword");
    private static HostConfiguration hostConfig;
    private static HttpState httpState;
    private File muleHome;
    private File mavenRepo = null;
    private HttpClient client;

    public LibraryDownloader(File muleHome) {
        this.muleHome = muleHome;
        String mavenRepoVar = System.getProperty("m2.repo");
        if (!StringUtils.isBlank((String)mavenRepoVar)) {
            this.mavenRepo = new File(mavenRepoVar).getAbsoluteFile();
            if (!this.mavenRepo.exists() || !this.mavenRepo.isDirectory()) {
                this.mavenRepo = null;
            }
        }
        this.client = new HttpClient();
        HttpConnectionManagerParams connParams = new HttpConnectionManagerParams();
        connParams.setConnectionTimeout(10000);
        this.client.getHttpConnectionManager().setParams(connParams);
        hostConfig = new HostConfiguration();
        if (StringUtils.isNotBlank((String)proxyHostname)) {
            hostConfig.setProxy(proxyHostname, NumberUtils.toInt((String)proxyPort));
        }
        httpState = new HttpState();
        if (StringUtils.isNotBlank((String)proxyUsername)) {
            httpState.setProxyCredentials(new AuthScope(null, -1, null, null), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
        }
    }

    public List downloadLibraries() throws IOException {
        ArrayList<URL> libraries = new ArrayList<URL>();
        try {
            libraries.add(this.getLibrary(REPO_CENTRAL, "/javax/activation/activation/1.1/activation-1.1.jar", "activation.jar"));
            libraries.add(this.getLibrary(REPO_CENTRAL, "/javax/mail/mail/1.4/mail-1.4.jar", "mail.jar"));
            libraries.add(this.getLibrary(REPO_MULESOURCE, "/script/jsr223/1.0/jsr223-1.0.jar", "jsr223.jar"));
            return libraries;
        }
        catch (UnknownHostException uhe) {
            System.err.println();
            IOException ex = new IOException("Unable to reach a remote repository, this is most likely because you are behind a firewall and have not configured your HTTP proxy settings in $MULE_HOME/conf/wrapper.conf.");
            ex.initCause(uhe);
            throw ex;
        }
        catch (ConnectTimeoutException e) {
            System.err.println();
            IOException ex = new IOException("Unable to reach a remote repository, this is most likely because you are behind a firewall and have not configured your HTTP proxy settings in $MULE_HOME/conf/wrapper.conf.");
            ex.initCause(e);
            throw ex;
        }
    }

    private URL getLibrary(String repository, String path, String destinationFileName) throws IOException {
        WrapperManager.signalStarting((int)120000);
        URL url = null;
        if (this.mavenRepo != null) {
            url = this.copyLibrary(path, destinationFileName);
        }
        if (url == null) {
            url = this.downloadLibrary(repository, path, destinationFileName);
        }
        return url;
    }

    private URL copyLibrary(String path, String destinationFileName) throws IOException {
        File sourceFile = new File(this.mavenRepo, path).getCanonicalFile();
        if (sourceFile.exists()) {
            System.out.print("Copying from local repository " + sourceFile.getAbsolutePath() + " ...");
            File destinationFile = new File(new File(this.muleHome, "/lib/user").getCanonicalFile(), destinationFileName).getCanonicalFile();
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            System.out.println("done");
            return destinationFile.toURL();
        }
        return null;
    }

    private URL downloadLibrary(String repository, String path, String destinationFileName) throws IOException {
        String url = repository + path;
        GetMethod httpMethod = new GetMethod(url);
        try {
            System.out.print("Downloading " + url + " ...");
            this.client.executeMethod(hostConfig, (HttpMethod)httpMethod, httpState);
            if (httpMethod.getStatusCode() == 200) {
                File destinationFile = new File(new File(this.muleHome, "/lib/user"), destinationFileName);
                FileUtils.copyStreamToFile((InputStream)httpMethod.getResponseBodyAsStream(), (File)destinationFile);
                System.out.println("done");
                URL uRL = destinationFile.toURL();
                return uRL;
            }
            System.out.println();
            throw new IOException("HTTP request failed: " + httpMethod.getStatusLine().toString());
        }
        finally {
            httpMethod.releaseConnection();
        }
    }
}

