/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.module.atom.routing.EntryLastUpdatedFilter;
import org.mule.module.atom.transformers.ObjectToFeed;
import org.mule.routing.AbstractSplitter;

public class FeedSplitter
extends AbstractSplitter {
    protected final transient Log logger = LogFactory.getLog(FeedSplitter.class);
    public static final String FEED_PROPERTY = "feed.object";
    private Filter entryFilter;
    private ObjectToFeed objectToFeed = new ObjectToFeed();

    public FeedSplitter() {
        this.entryFilter = new EntryLastUpdatedFilter(null);
    }

    protected List<MuleMessage> splitMessage(MuleEvent event) throws MuleException {
        ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
        if ((Integer)event.getMessage().getInboundProperty("Content-Length", (Object)-1) == 0) {
            this.logger.info((Object)"Feed has no content, ignoring");
            return messages;
        }
        try {
            Object payload = event.getMessage().getPayload();
            Feed feed = payload instanceof Feed ? (Feed)payload : (Feed)this.objectToFeed.transform(event.getMessage().getPayload());
            TreeSet<Entry> entries = new TreeSet<Entry>(new EntryComparator());
            entries.addAll(feed.getEntries());
            for (Entry entry : entries) {
                DefaultMuleMessage m = new DefaultMuleMessage((Object)entry, event.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept((MuleMessage)m)) continue;
                m.setInvocationProperty(FEED_PROPERTY, (Object)feed);
                messages.add((MuleMessage)m);
            }
            return messages;
        }
        catch (TransformerException e) {
            throw new MessagingException(e.getI18nMessage(), event, (Throwable)e);
        }
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    class EntryComparator
    implements Comparator<Entry> {
        EntryComparator() {
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            if (e1 == null && e2 != null) {
                return -1;
            }
            if (e1 != null && e2 == null) {
                return 1;
            }
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1.getPublished() != null && e1.getPublished().before(e2.getPublished())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

