/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.endpoint;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.AbstractMetaEndpointBuilder;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.module.atom.endpoint.AtomInboundEndpoint;
import org.mule.module.atom.routing.EntryLastUpdatedFilter;
import org.mule.module.atom.routing.FeedSplitter;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.util.StringUtils;

public class AtomEndpointBuilder
extends AbstractMetaEndpointBuilder {
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";
    private boolean splitFeed = true;
    private String lastUpdate = null;
    private long pollingFrequency = 1000L;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private final SimpleDateFormat shortDateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public AtomEndpointBuilder() {
    }

    public AtomEndpointBuilder(EndpointURIEndpointBuilder global) throws EndpointException {
        super(global);
    }

    public AtomEndpointBuilder(URIBuilder uriBuilder) {
        super(uriBuilder);
    }

    public AtomEndpointBuilder(String address, MuleContext muleContext) {
        super(address, muleContext);
    }

    protected AtomEndpointBuilder(EndpointURI endpointURI) {
        super(endpointURI);
    }

    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        try {
            Date date = this.formatDate(this.getLastUpdate());
            if (this.isSplitFeed()) {
                EntryLastUpdatedFilter filter = new EntryLastUpdatedFilter(date);
                FeedSplitter splitter = new FeedSplitter();
                splitter.setEntryFilter(filter);
                this.addMessageProcessor((MessageProcessor)splitter);
            }
            AtomInboundEndpoint in = new AtomInboundEndpoint(this.isSplitFeed(), date, super.buildInboundEndpoint());
            in.registerSupportedProtocol("http");
            in.registerSupportedProtocol("https");
            in.registerSupportedProtocol("vm");
            if (in.getConnector() instanceof HttpPollingConnector) {
                ((HttpPollingConnector)in.getConnector()).setPollingFrequency(this.pollingFrequency);
            }
            return in;
        }
        catch (ParseException e) {
            throw new EndpointException((Throwable)e);
        }
    }

    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        throw new UnsupportedOperationException("Outbound ATOM endpoints not supported");
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isSplitFeed() {
        return this.splitFeed;
    }

    public void setSplitFeed(boolean splitFeed) {
        this.splitFeed = splitFeed;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    protected Date formatDate(String date) throws ParseException {
        Date lastUpdateDate = null;
        if (StringUtils.isNotBlank((String)date)) {
            lastUpdateDate = this.lastUpdate.length() == 10 ? this.shortDateFormatter.parse(date) : this.dateFormatter.parse(date);
        }
        return lastUpdateDate;
    }
}

