/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.AbstractRequestContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleRequestContext
extends AbstractRequestContext
implements RequestContext {
    private final MuleMessage request;
    private HttpSession session;
    private MuleEventContext event;
    private IRI baseIri;

    public MuleRequestContext(Provider context, MuleEventContext event, MuleMessage request, String contextPath, IRI baseIri) {
        super(context, MuleRequestContext.getMethod(request), new IRI(contextPath), baseIri);
        this.baseIri = baseIri;
        this.request = request;
        this.event = event;
        this.session = null;
        this.principal = null;
        this.subject = context.resolveSubject((RequestContext)this);
        this.target = context.resolveTarget((RequestContext)this);
    }

    private static String getMethod(MuleMessage request) {
        return request.getStringProperty("http.method", "");
    }

    public Locale getPreferredLocale() {
        return null;
    }

    public Locale[] getPreferredLocales() {
        return null;
    }

    public String getTargetBasePath() {
        return this.event.getEndpointURI().getPath();
    }

    public Object getProperty(RequestContext.Property property) {
        switch (property) {
            case SESSIONID: {
                return this.session != null ? this.session.getId() : null;
            }
            case SESSIONCREATED: {
                return this.session != null ? new Date(this.session.getCreationTime()) : null;
            }
            case SESSIONACCESSED: {
                return this.session != null ? new Date(this.session.getLastAccessedTime()) : null;
            }
            case SESSIONTIMEOUT: {
                return this.session != null ? this.session.getMaxInactiveInterval() : -1;
            }
            case CHARACTERENCODING: {
                return this.request.getEncoding();
            }
            case LOCALES: {
                return null;
            }
            case PROTOCOL: {
                return this.request.getProperty("http.version");
            }
            case REMOTEADDRESS: {
                return null;
            }
            case REMOTEHOST: {
                return this.baseIri.getHost();
            }
            case REMOTEUSER: {
                return this.baseIri.getUserInfo();
            }
            case SCHEME: {
                return this.baseIri.getScheme();
            }
            case PRINCIPAL: {
                return null;
            }
            case AUTHTYPE: {
                return null;
            }
            case CONTENTLENGTH: {
                return this.request.getProperty("Content-Length");
            }
            case CONTENTTYPE: {
                return this.request.getProperty("Content-Type");
            }
            case CONTEXTPATH: {
                return "";
            }
            case LOCALADDR: {
                return "";
            }
            case LOCALNAME: {
                return "";
            }
            case SERVERNAME: {
                return "";
            }
            case SERVERPORT: {
                return "";
            }
        }
        throw new UnsupportedOperationException("Property " + property.name() + " is not supported.");
    }

    public Reader getReader() throws IOException {
        Object payload = this.request.getPayload();
        if (payload instanceof Reader) {
            return (Reader)payload;
        }
        if (payload instanceof InputStream) {
            return new InputStreamReader((InputStream)payload);
        }
        if (payload instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])payload));
        }
        try {
            return new StringReader(this.request.getPayloadAsString());
        }
        catch (Exception e) {
            IOException e2 = new IOException("Could not convert message to String.");
            e2.initCause(e);
            throw e2;
        }
    }

    public InputStream getInputStream() throws IOException {
        Object payload = this.request.getPayload();
        if (payload instanceof InputStream) {
            return (InputStream)payload;
        }
        if (payload instanceof byte[]) {
            return new ByteArrayInputStream((byte[])payload);
        }
        try {
            return new ByteArrayInputStream(this.request.getPayloadAsString().getBytes());
        }
        catch (Exception e) {
            IOException e2 = new IOException("Could not convert message to String.");
            e2.initCause(e);
            throw e2;
        }
    }

    public RequestContext setAttribute(RequestContext.Scope scope, String name, Object value) {
        switch (scope) {
            case REQUEST: {
                this.request.setProperty(name, value);
                break;
            }
            case SESSION: {
                this.event.getSession().setProperty((Object)name, value);
            }
        }
        return this;
    }

    public Object getAttribute(RequestContext.Scope scope, String name) {
        switch (scope) {
            case REQUEST: {
                return this.request.getProperty(name);
            }
            case SESSION: {
                if (this.event.getSession() == null) break;
                return this.event.getSession().getProperty((Object)name);
            }
        }
        return null;
    }

    public String[] getAttributeNames(RequestContext.Scope scope) {
        switch (scope) {
            case REQUEST: {
                Set names = this.request.getPropertyNames();
                return names.toArray(new String[names.size()]);
            }
            case SESSION: {
                return new String[0];
            }
        }
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public List<String> getParameters(String name) {
        return Collections.EMPTY_LIST;
    }

    public Date getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        Object prop = this.request.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.toString();
    }

    public String[] getHeaderNames() {
        Set propNames = this.request.getPropertyNames();
        return propNames.toArray(new String[propNames.size()]);
    }

    public Object[] getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        Set propNames = this.request.getPropertyNames();
        for (Object n : propNames) {
            Object prop = this.request.getProperty((String)n);
            if (!(prop instanceof String)) continue;
            values.add((String)prop);
        }
        return values.toArray();
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public String getContextPath() {
        return this.event.getEndpointURI().getPath();
    }
}

