/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.HashSet;
import java.util.Set;
import org.apache.abdera.i18n.templates.Route;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIRouteFilter
implements Filter {
    private Set<String> verbs;
    private Route route;

    public void setRoute(String routePattern) {
        this.route = new Route("", routePattern);
    }

    public void setVerbs(String verbString) {
        if (verbString.equals("*")) {
            return;
        }
        String[] split = verbString.split(" ");
        this.verbs = new HashSet<String>();
        for (String s : split) {
            this.verbs.add(s.toUpperCase());
        }
    }

    public void setVerbs(Set<String> verbs) {
        this.verbs = verbs;
    }

    public boolean accept(MuleMessage message) {
        String method = message.getStringProperty("http.method", "");
        if (this.verbs != null && !this.verbs.contains(method)) {
            return false;
        }
        String path = message.getStringProperty("http.request", "");
        return this.route.match(path);
    }
}

