/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.processor;

import java.util.List;
import java.util.regex.Pattern;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.odata.AbstractRouterInterface;
import org.mule.module.apikit.odata.ODataPayload;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.metadata.OdataMetadataManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;
import reactor.core.publisher.Mono;

public abstract class ODataRequestProcessor {
    public static final Pattern LEADING_SLASH = Pattern.compile("^\\/*");
    protected OdataContext oDataContext;

    public ODataRequestProcessor(OdataContext oDataContext) {
        this.oDataContext = oDataContext;
    }

    public abstract Mono<ODataPayload<?>> process(CoreEvent var1, AbstractRouterInterface var2, List<ODataPayloadFormatter.Format> var3);

    protected OdataMetadataManager getMetadataManager() {
        return this.oDataContext.getOdataMetadataManager();
    }

    protected String getProtocol(HttpRequestAttributes attributes) {
        String protocol = attributes.getScheme();
        return protocol;
    }

    protected String getHost(HttpRequestAttributes attributes) {
        String cloudHubFullDomain = System.getProperty("fullDomain");
        if (!StringUtils.isBlank((String)cloudHubFullDomain)) {
            return cloudHubFullDomain;
        }
        return (String)attributes.getHeaders().get((Object)"host");
    }

    protected String getCompleteUrl(HttpRequestAttributes attributes) {
        String path = attributes.getRequestPath();
        String url = this.getProtocol(attributes) + "://" + ODataRequestProcessor.sanitizeHost(this.getHost(attributes) + path);
        return url;
    }

    private static String sanitizeHost(String host) {
        return LEADING_SLASH.matcher(host).replaceFirst("");
    }
}

