/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.processor;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.mule.module.apikit.odata.exception.ODataBadRequestException;
import org.mule.module.apikit.odata.exception.ODataInvalidFormatException;
import org.mule.module.apikit.odata.util.EDMTypeConverter;
import org.odata4j.edm.EdmSimpleType;

public class BodyToJsonConverter {
    private static final String NAMESPACE_DECLARATION_REGEX = "xmlns:(\\w+)=.*?([\"']).*?([\"'])";
    private static final Pattern NAMESPACE_DECLARATION_PATTERN = Pattern.compile("xmlns:(\\w+)=.*?([\"']).*?([\"'])");

    public static String convertPayload(String entity, boolean isXMLFormat, String payloadAsString) throws ODataBadRequestException {
        if (isXMLFormat) {
            return BodyToJsonConverter.adaptBodyToJson(payloadAsString).toString();
        }
        if (!BodyToJsonConverter.isValidJson(payloadAsString)) {
            throw new ODataInvalidFormatException("Invalid format.");
        }
        return payloadAsString;
    }

    private static boolean isValidJson(String payload) {
        try {
            new JSONObject(payload);
            return true;
        }
        catch (JSONException ex) {
            return false;
        }
    }

    private static Set<String> getNamespaces(String xmlString) {
        HashSet<String> namespaces = new HashSet<String>();
        Matcher m = NAMESPACE_DECLARATION_PATTERN.matcher(xmlString);
        while (m.find()) {
            namespaces.add(m.group(1));
        }
        return namespaces;
    }

    private static String removeNamespaceFromKey(String key, Set<String> namespaces) {
        for (String namespace : namespaces) {
            if (!key.startsWith(namespace + ":")) continue;
            return key.replaceFirst("^(" + namespace + ":)(\\w+)$", "$2");
        }
        return key;
    }

    private static JSONObject removeNamespaces(JSONObject jsonObject, Set<String> namespaces) {
        ImmutableSet keys = ImmutableSet.copyOf((Collection)jsonObject.keySet());
        for (String key : keys) {
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                value = BodyToJsonConverter.removeNamespaces((JSONObject)value, namespaces);
            }
            jsonObject.remove(key);
            jsonObject.put(BodyToJsonConverter.removeNamespaceFromKey(key, namespaces), value);
        }
        return jsonObject;
    }

    private static JSONObject adaptBodyToJson(String body) throws ODataInvalidFormatException {
        try {
            JSONObject jsonObject = BodyToJsonConverter.removeNamespaces(XML.toJSONObject((String)body), BodyToJsonConverter.getNamespaces(body));
            JSONObject entry = jsonObject.getJSONObject("entry");
            JSONObject content = entry.getJSONObject("content");
            JSONObject properties = content.getJSONObject("properties");
            ImmutableSet keys = ImmutableSet.copyOf((Collection)properties.keySet());
            for (String key : keys) {
                Object value = properties.get(key);
                if (value instanceof JSONObject) {
                    properties.put(key, BodyToJsonConverter.getContent((JSONObject)value));
                    continue;
                }
                properties.put(key, (Object)value.toString());
            }
            return properties;
        }
        catch (JSONException e) {
            throw new ODataInvalidFormatException("Invalid format.");
        }
    }

    @Nullable
    private static Object getContent(JSONObject object) throws ODataInvalidFormatException {
        String key = "content";
        if (BodyToJsonConverter.isNull(object)) {
            return null;
        }
        try {
            EdmSimpleType type = BodyToJsonConverter.getEdmType(object);
            if (EdmSimpleType.BOOLEAN.equals((Object)type)) {
                return object.getBoolean("content");
            }
            if (EdmSimpleType.DECIMAL.equals((Object)type)) {
                return new BigDecimal(object.getString("content"));
            }
            if (EdmSimpleType.DOUBLE.equals((Object)type)) {
                return object.getDouble("content");
            }
            if (EdmSimpleType.SINGLE.equals((Object)type)) {
                return object.getDouble("content");
            }
            if (EdmSimpleType.INT64.equals((Object)type)) {
                return object.getLong("content");
            }
            if (EdmSimpleType.INT16.equals((Object)type) || EdmSimpleType.INT32.equals((Object)type)) {
                return object.getInt("content");
            }
            return BodyToJsonConverter.getString(object.get("content"));
        }
        catch (JSONException e) {
            throw new ODataInvalidFormatException("Invalid format.");
        }
    }

    private static String getString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    private static boolean isNull(JSONObject object) {
        try {
            return object.getBoolean("null");
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static EdmSimpleType getEdmType(JSONObject object) {
        try {
            return EDMTypeConverter.convert(object.getString("type"));
        }
        catch (JSONException e) {
            return EdmSimpleType.STRING;
        }
    }
}

