/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.error;

import java.util.List;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.odata.ODataFormatHandler;
import org.mule.module.apikit.odata.exception.ODataBadRequestException;
import org.mule.module.apikit.odata.exception.ODataException;
import org.mule.module.apikit.odata.exception.ODataInternalServerErrorException;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.util.CoreEventUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.http.api.HttpConstants;

public class ODataErrorHandler {
    private static final String ATOM_ERROR_ENVELOPE = "<?xml version=\"1.0\" encoding=\"utf-8\"?><m:error xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><m:code /><m:message xml:lang=\"en-US\">%%ERRORMSG%%</m:message></m:error>";
    private static final String JSON_ERROR_ENVELOPE = "{\"odata.error\":{\"code\":\"\",\"message\":{\"lang\":\"en-US\",\"value\":\"%%ERRORMSG%%\"}}}";
    private static final String ERROR_MSG_PLACEHOLDER = "%%ERRORMSG%%";

    public static CoreEvent handle(CoreEvent event, Exception ex) {
        return ODataErrorHandler.handle(event, ex, null);
    }

    public static CoreEvent handle(CoreEvent event, Throwable ex, List<ODataPayloadFormatter.Format> formats) {
        Throwable exceptionToBeThrown;
        Throwable cause = ExceptionUtils.getMessagingExceptionCause((Throwable)ex);
        Throwable throwable = exceptionToBeThrown = cause != null ? cause : ex;
        if (exceptionToBeThrown instanceof MuleException) {
            exceptionToBeThrown = ODataErrorHandler.processMuleException((MuleException)exceptionToBeThrown);
        }
        String payload = null;
        MediaType mediaType = null;
        if (ODataErrorHandler.isJsonFormat(formats, event)) {
            payload = JSON_ERROR_ENVELOPE.replace(ERROR_MSG_PLACEHOLDER, exceptionToBeThrown.getMessage() != null ? exceptionToBeThrown.getMessage().replace('\"', '\'') : "");
            mediaType = MediaType.APPLICATION_JSON;
        } else {
            payload = ATOM_ERROR_ENVELOPE.replace(ERROR_MSG_PLACEHOLDER, exceptionToBeThrown.getMessage() != null ? exceptionToBeThrown.getMessage() : exceptionToBeThrown.getClass().getName());
            mediaType = MediaType.APPLICATION_XML;
        }
        Message message = Message.builder().value((Object)payload).mediaType(mediaType).build();
        int httpStatus = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
        if (exceptionToBeThrown instanceof ODataException) {
            httpStatus = ((ODataException)exceptionToBeThrown).getHttpStatus();
        }
        return CoreEvent.builder((CoreEvent)event).message(message).addVariable("httpStatus", (Object)httpStatus).build();
    }

    private static ODataException processMuleException(MuleException ex) {
        if (ex instanceof BadRequestException) {
            return new ODataBadRequestException(ex.getMessage(), (Throwable)ex);
        }
        return new ODataInternalServerErrorException((Exception)ex);
    }

    private static boolean isJsonFormat(List<ODataPayloadFormatter.Format> formats, CoreEvent event) {
        try {
            if (formats == null) {
                formats = ODataFormatHandler.getFormats(CoreEventUtils.getHttpRequestAttributes(event));
            }
            return formats.contains((Object)ODataPayloadFormatter.Format.Json) && !formats.contains((Object)ODataPayloadFormatter.Format.Atom);
        }
        catch (ODataException oDataException) {
            return false;
        }
    }
}

