/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.module.apikit.model.Property;
import org.mule.module.apikit.model.exception.InvalidModelException;

public class Entity {
    private String name;
    private String remote;
    private boolean hasProperties;
    private static final Set<String> exceptionalCases = new HashSet<String>(Arrays.asList("ay", "ey", "iy", "oy", "uy"));
    private final List<Property> properties = new ArrayList<Property>();

    public Entity(String name) throws InvalidModelException {
        this.setName(name);
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        return this.name;
    }

    public String getCollectionName() {
        return Entity.pluralizeName(this.name);
    }

    public String getIdElementName() {
        return this.name.toLowerCase().endsWith("id") ? this.name + "_id" : this.name + "Id";
    }

    public void setPropertiesFound(boolean value) {
        this.hasProperties = value;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) throws InvalidModelException {
        this.remote = remote;
    }

    public boolean isValid() throws InvalidModelException {
        if (!this.isValid(this.name)) {
            throw new InvalidModelException("there are entities with empty names, please fix the model");
        }
        if (!this.hasProperties) {
            throw new InvalidModelException("the entity named '" + this.name + "' has no properties defined");
        }
        if (!this.isValid(this.remote)) {
            throw new InvalidModelException("the entity named '" + this.name + "' is missing the remote field definition");
        }
        return true;
    }

    private boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Property property : this.properties) {
            if (!Boolean.valueOf(property.getKey()).booleanValue()) continue;
            keys.add(property.getName());
        }
        return keys;
    }

    public static String pluralizeName(String name) {
        if (name.endsWith("List") || "any".equalsIgnoreCase(name)) {
            return name;
        }
        if (name.endsWith("s")) {
            return name.endsWith("ss") ? name + "es" : name;
        }
        if (name.endsWith("y") && !exceptionalCases.contains(name.substring(name.length() - 2))) {
            return name.substring(0, name.length() - 1) + "ies";
        }
        return name + "s";
    }
}

