/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import org.mule.module.apikit.model.exception.InvalidModelException;

public class Property {
    private String name;
    private String type;
    private String nullable;
    private String key;

    public Property(String name) throws InvalidModelException {
        this.setName(name);
    }

    private void setName(String name) throws InvalidModelException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidModelException {
        this.type = type;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) throws InvalidModelException {
        this.nullable = nullable;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) throws InvalidModelException {
        if (!this.isValid(key)) {
            throw new InvalidModelException();
        }
        this.key = key;
    }

    public boolean isValid() throws InvalidModelException {
        if (!this.isValid(this.name)) {
            throw new InvalidModelException("a field name is missing");
        }
        if (!this.isValid(this.type)) {
            throw new InvalidModelException("the field '" + this.name + "' is missing the 'type' required property");
        }
        if (!this.isValid(this.nullable)) {
            throw new InvalidModelException("the field '" + this.name + "' is missing the 'nullable' required property");
        }
        if (!this.isValid(this.key)) {
            throw new InvalidModelException("the field '" + this.name + "' is missing the 'type' required property");
        }
        return true;
    }

    private boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }
}

