/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.uritemplate.parse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.URITemplateMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.URITemplateParseException;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.expression.URITemplateExpression;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.parse.CharMatchers;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.parse.ExpressionParser;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.parse.LiteralParser;
import org.mule.module.json.internal.shaded.com.github.fge.uritemplate.parse.TemplateParser;

public final class URITemplateParser {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(URITemplateMessageBundle.class);
    private static final CharMatcher BEGIN_EXPRESSION = CharMatcher.is((char)'{');

    private URITemplateParser() {
    }

    public static List<URITemplateExpression> parse(String input) throws URITemplateParseException {
        return URITemplateParser.parse(CharBuffer.wrap(input).asReadOnlyBuffer());
    }

    @VisibleForTesting
    static List<URITemplateExpression> parse(CharBuffer buffer) throws URITemplateParseException {
        ArrayList ret = Lists.newArrayList();
        while (buffer.hasRemaining()) {
            TemplateParser templateParser = URITemplateParser.selectParser(buffer);
            URITemplateExpression expression = templateParser.parse(buffer);
            ret.add(expression);
        }
        return ret;
    }

    private static TemplateParser selectParser(CharBuffer buffer) throws URITemplateParseException {
        TemplateParser parser;
        char c = buffer.charAt(0);
        if (CharMatchers.LITERALS.matches(c)) {
            parser = new LiteralParser();
        } else if (BEGIN_EXPRESSION.matches(c)) {
            parser = new ExpressionParser();
        } else {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.noParser"), buffer);
        }
        return parser;
    }
}

