/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.mule.module.json.internal.shaded.com.github.fge.Thawed;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.InternalBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.provider.MessageSourceProvider;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source.MessageSource;

public final class MessageBundleBuilder
implements Thawed<MessageBundle> {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    MessageBundleBuilder() {
    }

    MessageBundleBuilder(MessageBundle bundle) {
        this.providers.addAll(bundle.providers);
    }

    public MessageBundleBuilder appendProvider(MessageSourceProvider provider) {
        BUNDLE.checkNotNull(provider, "cfg.nullProvider");
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependProvider(MessageSourceProvider provider) {
        BUNDLE.checkNotNull(provider, "cfg.nullProvider");
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundleBuilder appendSource(MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependSource(MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundleBuilder appendSource(Locale locale, MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependSource(Locale locale, MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundleBuilder appendBundle(MessageBundle bundle) {
        BUNDLE.checkNotNull(bundle, "cfg.nullBundle");
        this.providers.addAll(bundle.providers);
        return this;
    }

    public MessageBundleBuilder prependBundle(MessageBundle bundle) {
        BUNDLE.checkNotNull(bundle, "cfg.nullBundle");
        ArrayList<MessageSourceProvider> list = new ArrayList<MessageSourceProvider>();
        list.addAll(bundle.providers);
        list.addAll(this.providers);
        this.providers.clear();
        this.providers.addAll(list);
        return this;
    }

    @Override
    public MessageBundle freeze() {
        return new MessageBundle(this);
    }
}

