/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import javax.annotation.concurrent.Immutable;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.SchemaLoader;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.ProcessingResult;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.ref.JsonRef;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ReportProvider;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SimpleJsonTree;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchemaImpl;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

@Immutable
public final class JsonValidator {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final SchemaLoader loader;
    private final ValidationProcessor processor;
    private final ReportProvider reportProvider;

    JsonValidator(SchemaLoader loader, ValidationProcessor processor, ReportProvider reportProvider) {
        this.loader = loader;
        this.processor = processor;
        this.reportProvider = reportProvider;
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance, boolean deepCheck) throws ProcessingException {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance, deepCheck);
        return ProcessingResult.of(this.processor, report, data).getReport();
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        return this.validate(schema, instance, false);
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance, boolean deepCheck) {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance, deepCheck);
        return ProcessingResult.uncheckedResult(this.processor, report, data).getReport();
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        return this.validateUnchecked(schema, instance, false);
    }

    JsonSchema buildJsonSchema(JsonNode schema, JsonPointer pointer) throws ProcessingException {
        SchemaTree tree = this.loader.load(schema).setPointer(pointer);
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("danglingRef")));
        }
        return new JsonSchemaImpl(this.processor, tree, this.reportProvider);
    }

    JsonSchema buildJsonSchema(String uri) throws ProcessingException {
        JsonRef ref = JsonRef.fromString(uri);
        if (!ref.isLegal()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("illegalJsonRef")));
        }
        SchemaTree tree = this.loader.get(ref.getLocator()).setPointer(ref.getPointer());
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("danglingRef")));
        }
        return new JsonSchemaImpl(this.processor, tree, this.reportProvider);
    }

    Processor<FullData, FullData> getProcessor() {
        return this.processor;
    }

    private FullData buildData(JsonNode schema, JsonNode instance, boolean deepCheck) {
        BUNDLE.checkNotNull(schema, "nullSchema");
        BUNDLE.checkNotNull(instance, "nullInstance");
        SchemaTree schemaTree = this.loader.load(schema);
        SimpleJsonTree tree = new SimpleJsonTree(instance);
        return new FullData(schemaTree, tree, deepCheck);
    }
}

