/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class PropertiesValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public PropertiesValidator(JsonNode digest) {
        super("properties");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get("required")) {
            builder.add((Object)element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        LinkedHashSet set = Sets.newLinkedHashSet(this.required);
        set.removeAll(Sets.newHashSet((Iterator)data.getInstance().getNode().fieldNames()));
        if (!set.isEmpty()) {
            report.error(this.newMsg(data, bundle, "err.common.object.missingMembers").put("required", this.required).putArgument("missing", PropertiesValidator.toArrayNode(set)));
        }
    }

    @Override
    public String toString() {
        return "required: " + this.required.size() + " properties";
    }
}

