/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JsonNumEquivalence;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class DraftV3TypeKeywordSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String ANY = "any";
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();

    public DraftV3TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isTextual()) {
            String found = node.textValue();
            if (!DraftV3TypeKeywordSyntaxChecker.typeIsValid(found)) {
                report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").putArgument("found", found).putArgument("valid", EnumSet.allOf(NodeType.class)));
            }
            return;
        }
        int size = node.size();
        HashSet set = Sets.newHashSet();
        boolean uniqueItems = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueItems = set.add(EQUIVALENCE.wrap((Object)element));
            if (type == NodeType.OBJECT) {
                pointers.add(JsonPointer.of(this.keyword, index));
                continue;
            }
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.OBJECT, NodeType.STRING)).putArgument("found", type));
                continue;
            }
            if (DraftV3TypeKeywordSyntaxChecker.typeIsValid(element.textValue())) continue;
            report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").put("index", index).putArgument("found", element.textValue()).putArgument("valid", EnumSet.allOf(NodeType.class)));
        }
        if (!uniqueItems) {
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
        }
    }

    private static boolean typeIsValid(String s) {
        return ANY.equals(s) || NodeType.fromName(s) != null;
    }
}

