/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.module.json.api.JsonError;
import org.mule.module.json.api.JsonSchemaDereferencingMode;
import org.mule.module.json.internal.JsonSchemaValidator;
import org.mule.module.json.internal.ValidatorCommonUtils;
import org.mule.module.json.internal.ValidatorKey;
import org.mule.module.json.internal.error.SchemaValidationException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.Dereferencing;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.uri.URITranslatorConfigurationBuilder;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JsonSchemaValidatorJavaJsonToolsWrapper
extends JsonSchemaValidator {
    private static final Pattern INVALID_REFERENCE_MESSAGE_PATTERN = Pattern.compile("fatal: URI.+is not absolute");
    private final JsonSchema jsonSchema;
    private final ObjectMapper objectMapper;

    public JsonSchemaValidatorJavaJsonToolsWrapper(ValidatorKey key, JsonNode jsonSchemaNode) {
        super(key);
        this.jsonSchema = this.loadSchemaLibrary(jsonSchemaNode, super.getSchemaLocation(), super.getSchemaRedirects(), super.getDereferencing());
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void validate(InputStream inputStream) {
        ProcessingReport report;
        JsonNode jsonNode = super.asJsonNode(inputStream);
        try {
            report = this.jsonSchema.validate(jsonNode, true);
        }
        catch (ProcessingException e) {
            Matcher messageMatcher = INVALID_REFERENCE_MESSAGE_PATTERN.matcher(e.getMessage());
            if (messageMatcher.find()) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid Schema References"), (Throwable)e);
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception was found while trying to validate against json schema. Content was: " + jsonNode.toString())), (Throwable)e);
        }
        if (!report.isSuccess()) {
            String jsonReport = this.reportAsJson(report, this.objectMapper);
            throw new SchemaValidationException(jsonReport);
        }
    }

    private JsonSchema loadSchemaLibrary(JsonNode jsonNode, String schemaLocation, Map<String, String> schemaRedirects, JsonSchemaDereferencingMode dereferencing) {
        JsonSchemaFactory factory = this.getFactoryAndLoadConfiguration(schemaRedirects, dereferencing);
        if (schemaLocation == null) {
            try {
                return factory.getJsonSchema(jsonNode);
            }
            catch (ProcessingException e) {
                throw new ModuleException("Invalid Schema", (ErrorTypeDefinition)JsonError.INVALID_SCHEMA, (Throwable)e);
            }
        }
        try {
            return factory.getJsonSchema(ValidatorCommonUtils.resolveLocationIfNecessary(schemaLocation));
        }
        catch (ProcessingException e) {
            throw new ModuleException(String.format("Could not load JSON schema [%s]. %s", schemaLocation, e.getMessage()), (ErrorTypeDefinition)JsonError.SCHEMA_NOT_FOUND, (Throwable)e);
        }
    }

    private JsonSchemaFactory getFactoryAndLoadConfiguration(Map<String, String> schemaRedirects, JsonSchemaDereferencingMode dereferencing) {
        URITranslatorConfigurationBuilder translatorConfigurationBuilder = URITranslatorConfiguration.newBuilder();
        for (Map.Entry<String, String> redirect : schemaRedirects.entrySet()) {
            String key = ValidatorCommonUtils.resolveLocationIfNecessary(redirect.getKey());
            String value = ValidatorCommonUtils.resolveLocationIfNecessary(redirect.getValue());
            translatorConfigurationBuilder.addSchemaRedirect(key, value);
        }
        LoadingConfigurationBuilder loadingConfigurationBuilder = LoadingConfiguration.newBuilder().dereferencing(dereferencing == JsonSchemaDereferencingMode.CANONICAL ? Dereferencing.CANONICAL : Dereferencing.INLINE).setURITranslatorConfiguration(translatorConfigurationBuilder.freeze());
        LoadingConfiguration loadingConfiguration = loadingConfigurationBuilder.freeze();
        return JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfiguration).freeze();
    }

    private String reportAsJson(ProcessingReport report, ObjectMapper objectMapper) {
        String jsonReport = "[" + Lists.newArrayList((Iterable)report).stream().map(p -> p.asJson().toString()).collect(Collectors.joining(",")) + "]";
        try {
            jsonReport = objectMapper.writer(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)objectMapper.readTree(jsonReport));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonReport;
    }
}

