/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.internal.zip;

import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempZipFile
extends ZipFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempZipFile.class);
    private final File tempFile;

    public TempZipFile(File f) throws IOException {
        super(f);
        this.tempFile = f;
    }

    public void close() throws IOException {
        super.close();
        this.tempFile.delete();
    }

    public void closeSafely() {
        block2: {
            try {
                this.close();
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn(String.format("Exception found while trying to close temporal zip file %s. %s", this.tempFile.getPath(), e.getMessage()), (Throwable)e);
            }
        }
    }
}

