/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.api.strategy.zip;

import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extension.compression.api.strategy.ArchiverStrategy;
import org.mule.extension.compression.internal.CompressionManager;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;

@DisplayName(value="Zip")
@Alias(value="zip-archiver")
public class ZipArchiverStrategy
implements ArchiverStrategy {
    @Inject
    private CompressionManager compressionManager;
    @Parameter
    @DisplayName(value="Force ZIP64")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    boolean forceZip64;

    @Override
    public Result<InputStream, Void> archive(Map<String, TypedValue<InputStream>> entries) {
        return this.compressionManager.asyncArchive(entries, this.forceZip64);
    }

    public boolean isForceZip64() {
        return this.forceZip64;
    }

    public void setForceZip64(boolean forceZip64) {
        this.forceZip64 = forceZip64;
    }
}

