/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.api.strategy.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.mule.extension.compression.api.strategy.DecompressorStrategy;
import org.mule.extension.compression.internal.error.exception.DecompressionException;
import org.mule.extension.compression.internal.error.exception.InvalidArchiveException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Gzip")
@Alias(value="gzip-decompressor")
public class GzipDecompressorStrategy
implements DecompressorStrategy {
    @Override
    public InputStream decompress(TypedValue<InputStream> compressed) {
        try {
            return new GZIPInputStream((InputStream)compressed.getValue());
        }
        catch (ZipException e) {
            throw new InvalidArchiveException(e);
        }
        catch (IOException e) {
            throw new DecompressionException(e);
        }
    }
}

