/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1.cache;

import com.github.fge.jackson.JsonLoader;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.MimeType;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;

public class SchemaCacheUtils {
    private static final String SEPARATOR = ",";

    public static String getSchemaCacheKey(Action action, String mimeTypeName) {
        StringBuilder key = new StringBuilder(action.getResource().getUri());
        key.append(SEPARATOR).append(action.getType());
        key.append(SEPARATOR).append(mimeTypeName);
        return key.toString();
    }

    public static Schema resolveXmlSchema(String schemaCacheKey, ApiSpecification api) {
        MimeType mimeType = SchemaCacheUtils.getMimeType(schemaCacheKey, api);
        Object compiledSchema = mimeType.getCompiledSchema();
        if (compiledSchema instanceof Schema) {
            return (Schema)compiledSchema;
        }
        String schema = mimeType.getSchema();
        if (api.getConsolidatedSchemas().containsKey(schema) && (compiledSchema = api.getCompiledSchemas().get(schema)) instanceof Schema) {
            return (Schema)compiledSchema;
        }
        throw new ApikitRuntimeException("XML Schema could not be resolved for key: " + schemaCacheKey);
    }

    private static MimeType getMimeType(String schemaCacheKey, ApiSpecification api) {
        String[] path = schemaCacheKey.split(SEPARATOR);
        Action action = api.getResource(path[0]).getAction(path[1]);
        return (MimeType)action.getBody().get(path[2]);
    }

    @Nullable
    public static Object resolveJsonSchema(String schemaCacheKey, ApiSpecification api) {
        MimeType mimeType = SchemaCacheUtils.getMimeType(schemaCacheKey, api);
        String path = (String)mimeType.getCompiledSchema();
        String schemaOrGlobalReference = mimeType.getSchema();
        try {
            if (api.getConsolidatedSchemas().containsKey(schemaOrGlobalReference)) {
                path = (String)api.getCompiledSchemas().get(schemaOrGlobalReference);
                if (path != null) {
                    return path;
                }
                return JsonLoader.fromString((String)((String)api.getConsolidatedSchemas().get(schemaOrGlobalReference)));
            }
            if (path != null) {
                return path;
            }
            if (schemaOrGlobalReference != null) {
                return JsonLoader.fromString((String)schemaOrGlobalReference);
            }
            return null;
        }
        catch (IOException e) {
            throw new ApikitRuntimeException("Json Schema could not be resolved for key: " + schemaCacheKey, e);
        }
    }
}

