/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.LimitedByteArrayOutputStream;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilder;

class APIKitMultipartStream
extends MultipartStream {
    private boolean readingPreamble = false;
    private byte[] preamble = new byte[0];
    private final long maxBytes;

    APIKitMultipartStream(InputStream input, byte[] boundary, int bufSize, long maxBytes) {
        super(input, boundary, bufSize);
        this.maxBytes = maxBytes;
    }

    public boolean readPreamble(MultipartEntityBuilder multipartEntityBuilder) throws InvalidFormParameterException {
        this.readingPreamble = true;
        boolean isNextPart = false;
        try {
            isNextPart = super.skipPreamble();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.preamble.length > 0) {
            multipartEntityBuilder.handlePreamble(this.preamble);
            this.preamble = new byte[0];
        }
        this.readingPreamble = false;
        return isNextPart;
    }

    public int discardBodyData() throws IOException {
        if (!this.readingPreamble) {
            LimitedByteArrayOutputStream content = new LimitedByteArrayOutputStream(this.maxBytes);
            return this.readBodyData(content);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int length = super.readBodyData((OutputStream)os);
        this.preamble = os.toByteArray();
        return length;
    }

    public void readEpilogue(MultipartEntityBuilder multipartEntityBuilder) throws InvalidFormParameterException {
        LimitedByteArrayOutputStream outputStream = new LimitedByteArrayOutputStream(this.maxBytes);
        int count = 0;
        try {
            while (true) {
                ++count;
                outputStream.write(this.readByte());
            }
        }
        catch (IOException e) {
            byte[] epilogue = new byte[count - 1];
            try {
                outputStream.flush();
                System.arraycopy(outputStream.toByteArray(), 0, epilogue, 0, count - 1);
                multipartEntityBuilder.handleEpilogue(epilogue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }
}

