/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.entity.mime.MIME;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.APIKitMultipartStream;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilder;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilderWithDefaults;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilderWithoutDefaults;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

public class MultipartBuilder {
    private static String MULTIPART_SIZE_LIMIT_PROPERTY_NAME = "apikit.multipart.size.limit";
    private static String MULTIPART_SIZE_LIMIT_DEFAULT = "268435456";
    private final String boundary;
    private final String contentType;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<String, Parameter> formParameters = new HashMap<String, Parameter>();
    private static Pattern NAME_PATTERN = Pattern.compile("(?i)Content-Disposition:\\s*form-data;[^\\n]*\\sname=([^\\n;]*?)[;\\n\\s]");
    private static Pattern FILE_NAME_PATTERN = Pattern.compile("(?i)filename=\"([^\"]+)\"");
    private static Pattern CONTENT_TYPE_PATTERN = Pattern.compile("(?i)Content-Type:\\s*([^\\n]+)");
    private final OptionalLong byteLength;
    private CursorStreamProvider cursorProvider;
    private InputStream inputStream;
    private final long sizeLimit;

    public MultipartBuilder(String contentType, String boundary, OptionalLong byteLength) {
        this.byteLength = byteLength;
        this.boundary = boundary;
        this.contentType = contentType;
        this.sizeLimit = Long.valueOf(System.getProperty(MULTIPART_SIZE_LIMIT_PROPERTY_NAME, MULTIPART_SIZE_LIMIT_DEFAULT));
    }

    public MultipartBuilder withDefaultValue(String key, String value) {
        this.defaultValues.put(key, value);
        return this;
    }

    public MultipartBuilder withExpectedParameter(String expectedKey, Parameter parameter) {
        this.formParameters.put(expectedKey, parameter);
        return this;
    }

    public MultipartBuilder withInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public MultipartBuilder withCursorProvider(CursorStreamProvider cursorProvider) {
        this.cursorProvider = cursorProvider;
        return this;
    }

    public Multipart build() throws InvalidFormParameterException {
        try {
            InputStream inputStream = this.cursorProvider != null ? (InputStream)this.cursorProvider.openCursor() : this.inputStream;
            APIKitMultipartStream multipartStream = new APIKitMultipartStream(inputStream, this.boundary.getBytes(MIME.UTF8_CHARSET), StreamUtils.BUFFER_SIZE, this.sizeLimit);
            HashSet<String> parametersInPayload = new HashSet<String>();
            MultipartEntityBuilder multipartEntityBuilder = this.defaultValues.isEmpty() && this.cursorProvider != null ? new MultipartEntityBuilderWithoutDefaults(this.contentType, (CursorProvider)this.cursorProvider, this.boundary, this.sizeLimit, this.byteLength) : new MultipartEntityBuilderWithDefaults(this.boundary, this.sizeLimit);
            boolean nextPart = multipartStream.readPreamble(multipartEntityBuilder);
            multipartEntityBuilder.handleBoundary(true);
            while (nextPart) {
                String headers = multipartStream.readHeaders();
                String string = this.getName(headers);
                String fileName = this.getFileName(headers);
                String contentType = this.getContentType(headers);
                parametersInPayload.add(string);
                multipartEntityBuilder.handlePart(multipartStream, this.formParameters.get(string), string, contentType, fileName, headers);
                nextPart = multipartStream.readBoundary();
                multipartEntityBuilder.handleBoundary(false);
            }
            for (Map.Entry<String, String> entry : this.defaultValues.entrySet()) {
                if (parametersInPayload.contains(entry.getKey())) continue;
                multipartEntityBuilder.addDefault(entry.getKey(), entry.getValue());
                multipartEntityBuilder.handleBoundary(false);
            }
            multipartEntityBuilder.handleStreamTermination();
            multipartStream.readEpilogue(multipartEntityBuilder);
            for (Map.Entry<String, String> entry : this.formParameters.entrySet()) {
                if (parametersInPayload.contains(entry.getKey()) || !((Parameter)entry.getValue()).isRequired() || !((Parameter)entry.getValue()).getDefaultValues().isEmpty()) continue;
                throw new InvalidFormParameterException("Required form parameter " + entry.getKey() + " not specified");
            }
            return multipartEntityBuilder.getOutput();
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidFormParameterException(e.getMessage());
        }
    }

    private String getFileName(String headers) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(headers);
        return !matcher.find() ? null : matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getName(String headers) throws InvalidFormParameterException {
        Matcher matcher = NAME_PATTERN.matcher(headers);
        if (!matcher.find()) {
            throw new InvalidFormParameterException("Unable to get name from form-data");
        }
        return matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getContentType(String headers) {
        Matcher matcher = CONTENT_TYPE_PATTERN.matcher(headers);
        return !matcher.find() ? MediaType.TEXT.toString() : matcher.group(1);
    }
}

