/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.extension.aggregator.internal.source.AggregatorListener;
import org.mule.runtime.api.cluster.ClusterService;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorManager
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatorManager.class);
    private static final String DEFAULT_TASK_SCHEDULING_PERIOD = "1000";
    private Map<String, AggregatorListener> registeredListeners;
    private Map<String, Runnable> availableAggregators;
    private final Object registeredAggregatorsModificationLock = new Object();
    private boolean initialized = false;
    private boolean started = false;
    private final AtomicBoolean contextStarted = new AtomicBoolean(false);
    private long taskSchedulingPeriod = Long.parseLong("1000");
    private PrimaryNodeLifecycleNotificationListener notificationListener;
    private MuleContextNotificationListener<MuleContextNotification> contextStartListener;
    private Scheduler scheduler;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    private ClusterService clusterService;
    @Inject
    private ConfigurationProperties configProperties;

    public Map<String, AggregatorListener> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public void setRegisteredListeners(Map<String, AggregatorListener> registeredListeners) {
        this.registeredListeners = registeredListeners;
    }

    public Map<String, Runnable> getAvailableAggregators() {
        return this.availableAggregators;
    }

    public void setAvailableAggregators(Map<String, Runnable> availableAggregators) {
        this.availableAggregators = availableAggregators;
    }

    public Object getRegisteredAggregatorsModificationLock() {
        return this.registeredAggregatorsModificationLock;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public AtomicBoolean getContextStarted() {
        return this.contextStarted;
    }

    public long getTaskSchedulingPeriod() {
        return this.taskSchedulingPeriod;
    }

    public void setTaskSchedulingPeriod(long taskSchedulingPeriod) {
        this.taskSchedulingPeriod = taskSchedulingPeriod;
    }

    public PrimaryNodeLifecycleNotificationListener getNotificationListener() {
        return this.notificationListener;
    }

    public void setNotificationListener(PrimaryNodeLifecycleNotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public MuleContextNotificationListener<MuleContextNotification> getContextStartListener() {
        return this.contextStartListener;
    }

    public void setContextStartListener(MuleContextNotificationListener<MuleContextNotification> contextStartListener) {
        this.contextStartListener = contextStartListener;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public NotificationListenerRegistry getNotificationListenerRegistry() {
        return this.notificationListenerRegistry;
    }

    public void setNotificationListenerRegistry(NotificationListenerRegistry notificationListenerRegistry) {
        this.notificationListenerRegistry = notificationListenerRegistry;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public ConfigurationProperties getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(ConfigurationProperties configProperties) {
        this.configProperties = configProperties;
    }

    public void initialise() throws InitialisationException {
        if (!this.initialized) {
            this.registeredListeners = new HashMap<String, AggregatorListener>();
            this.availableAggregators = new HashMap<String, Runnable>();
            this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this, this.notificationListenerRegistry);
            this.notificationListener.register();
            this.contextStartListener = new MuleContextNotificationListener<MuleContextNotification>(){

                public void onNotification(MuleContextNotification notification) {
                    if (String.valueOf(104).equals(notification.getAction().getIdentifier())) {
                        AggregatorManager.this.notificationListenerRegistry.unregisterListener((NotificationListener)this);
                        AggregatorManager.this.onContextStarted();
                    }
                }
            };
            this.notificationListenerRegistry.registerListener(this.contextStartListener);
            this.initialized = true;
        }
    }

    public void onContextStarted() {
        this.contextStartListener = null;
        this.contextStarted.set(true);
    }

    public void start() throws MuleException {
        if (this.clusterService.isPrimaryPollingInstance() && !this.started) {
            this.scheduler = this.schedulerService.cpuIntensiveScheduler();
            try {
                this.taskSchedulingPeriod = Long.parseLong(this.configProperties.resolveStringProperty("mule.aggregatorsSchedulingPeriod").orElse(this.configProperties.resolveStringProperty("mule.aggregatorsSchedulingPeriod").orElse(DEFAULT_TASK_SCHEDULING_PERIOD)));
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Error trying to configure '%s', the value could not be parsed to a long. Using default value: %d %s", new Object[]{"aggregatorsSchedulingPeriod", this.taskSchedulingPeriod, TimeUnit.MILLISECONDS}));
            }
            this.scheduler.scheduleAtFixedRate(this::syncAggregators, 0L, this.taskSchedulingPeriod, TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
            this.started = false;
        }
    }

    public void dispose() {
        if (this.initialized) {
            this.registeredListeners = null;
            this.availableAggregators = null;
            this.initialized = false;
            if (this.scheduler != null) {
                this.scheduler.stop();
                this.scheduler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAggregators() {
        if (this.contextStarted.get()) {
            Object object = this.registeredAggregatorsModificationLock;
            synchronized (object) {
                for (Runnable runnable : this.availableAggregators.values()) {
                    runnable.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAggregator(String aggregatorName, Runnable synchronizingTask) {
        Object object = this.registeredAggregatorsModificationLock;
        synchronized (object) {
            this.availableAggregators.put(aggregatorName, synchronizingTask);
        }
    }

    public void registerListener(String aggregatorName, AggregatorListener listener) throws MuleRuntimeException {
        if (!this.availableAggregators.keySet().contains(aggregatorName)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Listener is attempting to register to aggregator: '%s', but it does not exist", (Object[])new Object[]{aggregatorName}));
        }
        if (this.registeredListeners.containsKey(aggregatorName)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Aggregator '%s' already has a listener", (Object[])new Object[]{aggregatorName}));
        }
        this.registeredListeners.put(aggregatorName, listener);
    }

    public void unregisterListener(String aggregatorName, AggregatorListener listener) throws MuleRuntimeException {
        if (!this.availableAggregators.containsKey(aggregatorName)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Listener is attempting to unregister from aggregator: '%s', but it does not exist", (Object[])new Object[]{aggregatorName}));
        }
        if (!this.registeredListeners.remove(aggregatorName, (Object)listener)) {
            LOGGER.error(String.format("Listener is attempting to unregister from aggregator: '%s', but it does not exist", aggregatorName));
        }
    }

    public Optional<AggregatorListener> getListener(String aggregatorName) {
        return Optional.ofNullable(this.registeredListeners.get(aggregatorName));
    }

    public long getTaskSchedulingPeriodInMillis() {
        return this.taskSchedulingPeriod;
    }
}

