/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.privileged.executor;

import java.util.concurrent.TimeUnit;
import org.mule.extension.aggregator.api.AggregationAttributes;
import org.mule.extension.aggregator.internal.privileged.executor.AbstractAggregatorExecutor;
import org.mule.extension.aggregator.internal.storage.content.AggregatedContent;
import org.mule.extension.aggregator.internal.storage.content.SimpleAggregatedContent;
import org.mule.extension.aggregator.internal.storage.info.AggregatorSharedInformation;
import org.mule.extension.aggregator.internal.storage.info.SimpleAggregatorSharedInformation;
import org.mule.extension.aggregator.internal.task.AsyncTask;
import org.mule.extension.aggregator.internal.task.SimpleAsyncTask;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.extension.api.exception.ModuleException;

public abstract class SingleGroupAggregatorExecutor
extends AbstractAggregatorExecutor {
    private int groupSize;

    void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    void resetGroup() {
        this.getSharedInfoLocalCopy().setAggregatedContent(new SimpleAggregatedContent(this.groupSize));
        this.getSharedInfoLocalCopy().setAggregationId(UUID.getUUID());
    }

    String getAggregationId() {
        String id = this.getSharedInfoLocalCopy().getAggregationId();
        if (id == null) {
            id = UUID.getUUID();
            this.getSharedInfoLocalCopy().setAggregationId(id);
        }
        return id;
    }

    AggregationAttributes getAttributes(AggregatedContent aggregatedContent) {
        return new AggregationAttributes(this.getAggregationId(), aggregatedContent.getFirstValueArrivalTime(), aggregatedContent.getLastValueArrivalTime(), aggregatedContent.isComplete());
    }

    AggregatedContent getAggregatedContent() {
        AggregatedContent aggregatedContent = this.getSharedInfoLocalCopy().getAggregatedContent();
        if (aggregatedContent == null) {
            aggregatedContent = new SimpleAggregatedContent(this.groupSize);
            this.getSharedInfoLocalCopy().setAggregatedContent(aggregatedContent);
        }
        return aggregatedContent;
    }

    void registerAsyncAggregationIfNeeded(int delay, TimeUnit unit) {
        if (this.getSharedInfoLocalCopy().shouldRegisterNextAsyncAggregation()) {
            SimpleAsyncTask task = new SimpleAsyncTask(delay, unit);
            task.setRegistered(this.getCurrentTime());
            this.getSharedInfoLocalCopy().registerAsyncAggregationTask(task);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Registered task to be executed in %d %s", new Object[]{delay, unit}));
            }
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Attempted to register task but it was already registered");
        }
    }

    @Override
    boolean doScheduleRegisteredAsyncAggregations() {
        AsyncTask task = this.getSharedInfoLocalCopy().getRegisteredAsyncAggregationTask();
        if (task != null) {
            if (!task.isScheduled()) {
                this.scheduleTask(task, () -> this.executeSynchronized(() -> {
                    if (this.getSharedInfoLocalCopy().getRegisteredAsyncAggregationTask() != null && task.getId().equals(this.getSharedInfoLocalCopy().getRegisteredAsyncAggregationTask().getId())) {
                        this.onAsyncAggregationExecution();
                        this.getSharedInfoLocalCopy().unregisterAsyncAggregationTask();
                        return true;
                    }
                    return false;
                }));
                task.setScheduled();
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug(String.format("Scheduled task to be executed in %d %s", new Object[]{task.getDelay(), task.getDelayTimeUnit()}));
                }
            } else if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Attempted to schedule task but it was already scheduled");
            }
            return true;
        }
        return false;
    }

    @Override
    boolean doSetRegisteredAsyncAggregationsAsNotScheduled() {
        AsyncTask task = this.getSharedInfoLocalCopy().getRegisteredAsyncAggregationTask();
        if (task != null) {
            task.setUnscheduled();
            return true;
        }
        return false;
    }

    abstract void onAsyncAggregationExecution();

    @Override
    SimpleAggregatorSharedInformation getSharedInfoLocalCopy() throws ModuleException {
        return (SimpleAggregatorSharedInformation)super.getSharedInfoLocalCopy();
    }

    @Override
    AggregatorSharedInformation createSharedInfo() {
        return new SimpleAggregatorSharedInformation();
    }

    void onCompleteAggregation() {
        this.resetGroup();
        this.getSharedInfoLocalCopy().unregisterAsyncAggregationTask();
    }
}

