/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.transformer.ParametersTransformationResult;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.runtime.api.metadata.TypedValue;

public class ArgumentMismatchModuleException
extends JavaModuleException {
    public ArgumentMismatchModuleException(String failure, Executable executable, Map<String, TypedValue<Object>> args, ParametersTransformationResult transformationResult) {
        super(ArgumentMismatchModuleException.buildMessage(failure, executable, args, transformationResult, Optional.empty()), JavaModuleError.ARGUMENTS_MISMATCH);
    }

    public ArgumentMismatchModuleException(String failure, Executable executable, Map<String, TypedValue<Object>> args, ParametersTransformationResult transformationResult, Throwable cause) {
        super(ArgumentMismatchModuleException.buildMessage(failure, executable, args, transformationResult, JavaModuleUtils.getCauseMessage(cause)), JavaModuleError.ARGUMENTS_MISMATCH, cause);
    }

    private static String buildMessage(String failure, Executable executable, Map<String, TypedValue<Object>> args, ParametersTransformationResult transformationResult, Optional<String> cause) {
        StringBuilder sb = new StringBuilder().append(failure).append(". ");
        Parameter[] parameters = executable.getParameters();
        if (parameters.length > 0) {
            sb.append("\nExpected arguments are ").append(JavaModuleUtils.toHumanReadableArgs(executable)).append(" and invocation was attempted ").append(JavaModuleUtils.getArgumentsMessage(JavaModuleUtils.toHumanReadableArgs(args)));
        } else {
            sb.append("\nNo arguments were expected and invocation was attempted ").append(JavaModuleUtils.getArgumentsMessage(JavaModuleUtils.toHumanReadableArgs(args)));
        }
        if (!args.isEmpty()) {
            ArgumentMismatchModuleException.logMissing(transformationResult, sb);
            ArgumentMismatchModuleException.logNotTransformed(transformationResult, sb);
            ArgumentMismatchModuleException.logInvalidNullValues(args, sb, parameters);
        }
        sb.append(cause.map(causeMessage -> ": " + causeMessage).orElse("."));
        return sb.toString();
    }

    private static void logInvalidNullValues(Map<String, TypedValue<Object>> args, StringBuilder sb, Parameter[] parameters) {
        List nullPrimitives = Arrays.stream(parameters).filter(p -> p.getType().isPrimitive()).filter(p -> args.get(p.getName()) != null && ((TypedValue)args.get(p.getName())).getValue() == null).map(Parameter::getName).collect(Collectors.toList());
        if (!nullPrimitives.isEmpty()) {
            sb.append(".\n");
            if (nullPrimitives.size() == 1) {
                sb.append("Parameter '").append((String)nullPrimitives.get(0)).append("'").append(" cannot be assigned with null, but a null value was provided");
            } else {
                sb.append("Parameters ").append(nullPrimitives).append(" cannot be assigned with null, but null values were provided");
            }
        }
    }

    private static void logNotTransformed(ParametersTransformationResult transformationResult, StringBuilder sb) {
        if (!transformationResult.getFailedToTransform().isEmpty()) {
            sb.append(".\nNo suitable transformation was found to match the expected type for the parameter");
            if (transformationResult.getFailedToTransform().size() > 1) {
                sb.append("s");
            }
            sb.append(" ").append(transformationResult.getFailedToTransform());
        }
    }

    private static void logMissing(ParametersTransformationResult transformationResult, StringBuilder sb) {
        if (!transformationResult.getMissing().isEmpty()) {
            sb.append(".\nMissing parameter");
            if (transformationResult.getMissing().size() > 1) {
                sb.append("s are");
            }
            sb.append(" ").append(transformationResult.getMissing());
        }
    }
}

