/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.parameters;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class MethodIdentifier
extends ExecutableIdentifier {
    public static final String NAME = "Method";
    @Parameter
    @Alias(value="class")
    @ClassValue
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @MetadataKeyPart(order=1, providedByKeyResolver=false)
    @Summary(value="Fully qualified name of the Class containing the referenced Method")
    private String clazz;
    @Parameter
    @MetadataKeyPart(order=2)
    @Alias(value="method")
    @Summary(value="Represents the Method signature containing the method name and it's argument types.")
    private String methodId;

    public MethodIdentifier() {
    }

    public MethodIdentifier(Method method) {
        this.clazz = method.getDeclaringClass().getName();
        this.methodId = this.buildId(method.getName(), method.getParameterTypes());
    }

    public MethodIdentifier(String className, String methodId) {
        this.clazz = className;
        this.methodId = methodId;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public String getElementId() {
        return this.methodId;
    }

    @Override
    public boolean matches(Executable element) {
        return element instanceof Method && !Modifier.isStatic(element.getModifiers()) && this.getElementName().equals(element.getName()) && this.matchesArguments(element.getParameterTypes());
    }

    @Override
    public String getExecutableTypeName() {
        return NAME;
    }
}

