/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.exchange.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.mule.maven.exchange.model.ExchangeModel;

public class ExchangeModelSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public ExchangeModelSerializer() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public ExchangeModel read(File exchangeFile) throws IOException {
        return this.read(new FileInputStream(exchangeFile));
    }

    public ExchangeModel read(InputStream inputStream) throws IOException {
        try {
            return this.read(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ExchangeModel read(Reader reader) throws IOException {
        return (ExchangeModel)this.objectMapper.readValue(reader, ExchangeModel.class);
    }

    public void write(ExchangeModel model, File output) throws IOException {
        this.objectMapper.writeValue(output, (Object)model);
    }

    public void write(ExchangeModel model, Writer output) throws IOException {
        this.objectMapper.writeValue(output, (Object)model);
    }

    public void write(ExchangeModel model, OutputStream output) throws IOException {
        this.objectMapper.writeValue(output, (Object)model);
    }

    public void indent(boolean shouldIndent) {
        if (shouldIndent) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        } else {
            this.objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
    }
}

