/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.errorhandler;

import java.util.HashMap;
import java.util.Iterator;
import org.mule.example.errorhandler.ErrorManager;
import org.mule.example.errorhandler.ErrorMessage;
import org.mule.example.errorhandler.ExceptionHandler;
import org.mule.example.errorhandler.HandlerException;
import org.mule.example.errorhandler.LocaleMessage;

public abstract class AbstractExceptionHandler
implements ExceptionHandler {
    protected HashMap registry = new HashMap();
    private String endpointName;
    protected ErrorManager errorManager = null;

    public void registerException(Class exceptionClass) {
        this.registry.put(exceptionClass, exceptionClass);
    }

    public Iterator getRegisteredClasses() {
        return this.registry.keySet().iterator();
    }

    public void unRegisterException(Class exceptionClass) {
        this.registry.remove(exceptionClass);
    }

    public boolean isRegisteredFor(Class exceptionClass) {
        Class aClass = null;
        Iterator i = this.getRegisteredClasses();
        while (i.hasNext()) {
            aClass = (Class)i.next();
            if (!aClass.isAssignableFrom(exceptionClass)) continue;
            return true;
        }
        return false;
    }

    public void onException(ErrorMessage message) throws HandlerException {
        Throwable t = null;
        try {
            t = message.getException().toException();
        }
        catch (Exception e) {
            throw new HandlerException(LocaleMessage.unretrievedException(e), e);
        }
        if (!this.isRegisteredFor(t.getClass())) {
            throw new HandlerException(LocaleMessage.unhandledException(t.getClass(), this.getClass()));
        }
        this.processException(message, t);
    }

    protected abstract void processException(ErrorMessage var1, Throwable var2) throws HandlerException;

    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public String getendpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }
}

