/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.soap.RMSoapOutInterceptor;

import static org.mule.soap.internal.rm.RMUtils.isReliableMessagingEnable;

public class SkipReliableMessagingOutInterceptor extends AbstractSoapInterceptor {

  private final RMOutInterceptor rmLogicalOut;
  private final RMSoapOutInterceptor rmOutCodec;
  private final RMCaptureOutInterceptor rmCaptureOut;

  public SkipReliableMessagingOutInterceptor(RMOutInterceptor rmLogicalOut, RMSoapOutInterceptor rmOutCodec,
                                             RMCaptureOutInterceptor rmCaptureOut) {
    super(SkipReliableMessagingOutInterceptor.class.getName(), "setup");
    this.addBefore(SkipAddressingOutInterceptor.class.getName());
    this.rmLogicalOut = rmLogicalOut;
    this.rmOutCodec = rmOutCodec;
    this.rmCaptureOut = rmCaptureOut;
  }

  @Override
  public void handleMessage(SoapMessage soapMessage) {
    if (!isReliableMessagingEnable(soapMessage)) {
      soapMessage.getInterceptorChain().remove(rmLogicalOut);
      soapMessage.getInterceptorChain().remove(rmOutCodec);
      soapMessage.getInterceptorChain().remove(rmCaptureOut);
    }
  }
}
