/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.rm;

import org.mule.soap.internal.rm.DefaultTerminateSequenceRequest;

/**
 * A builder implementation to create {@link TerminateSequenceRequest}s
 *
 * @since 1.6
 */
public class TerminateSequenceRequestBuilder {

  private String sequenceIdentifier;

  public TerminateSequenceRequestBuilder sequenceIdentifier(String sequenceIdentifier) {
    this.sequenceIdentifier = sequenceIdentifier;
    return this;
  }

  public TerminateSequenceRequest build() {
    return new DefaultTerminateSequenceRequest(sequenceIdentifier);
  }
}
