/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.PersistenceUtils;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.mule.soap.api.message.ReliableMessagingProperties;

public class RMUtils {
    public static final String MULE_RM_ENABLE = "mule.reliablemessaging.enable";
    public static final String MULE_RM_SEQUENCE = "mule.reliablemessaging.sequence";
    public static final String MULE_ADDRESSING_ENABLE = "mule.addressing.enable";

    public static String getReliableMessagingSequence(Message message) {
        return (String)message.get((Object)MULE_RM_SEQUENCE);
    }

    public static boolean isReliableMessagingEnable(Message message) {
        return PropertyUtils.isTrue((Object)message.get((Object)MULE_RM_ENABLE));
    }

    public static boolean isAddressingEnable(Message message) {
        return PropertyUtils.isTrue((Object)message.get((Object)MULE_ADDRESSING_ENABLE));
    }

    public static void enableAddressing(Map<String, Object> props, org.mule.soap.api.message.AddressingProperties addressingProperties) {
        props.put("jakarta.xml.ws.addressing.context", RMUtils.buildCxfAddressingProperties(addressingProperties));
        props.put(MULE_ADDRESSING_ENABLE, Boolean.TRUE);
    }

    public static void enableReliableMessaging(Map<String, Object> props, ReliableMessagingProperties rmProperties, SourceSequence sourceSequence) {
        props.put(MULE_RM_SEQUENCE, rmProperties.getSequenceIdentifier());
        props.put(MAPAggregator.ADDRESSING_NAMESPACE, sourceSequence.getProtocol().getWSANamespace());
        props.put("org.apache.cxf.ws.rm.namespace", sourceSequence.getProtocol().getWSRMNamespace());
        props.put("org.apache.cxf.ws.rm.wsa-namespace", sourceSequence.getProtocol().getWSANamespace());
        props.put(MULE_ADDRESSING_ENABLE, Boolean.TRUE);
        props.put(MULE_RM_ENABLE, Boolean.TRUE);
    }

    public static void copySettings(Message request, Message response) {
        response.put((Object)MULE_RM_ENABLE, request.get((Object)MULE_RM_ENABLE));
        response.put((Object)MULE_RM_SEQUENCE, request.get((Object)MULE_RM_SEQUENCE));
        response.put((Object)MULE_ADDRESSING_ENABLE, request.get((Object)MULE_ADDRESSING_ENABLE));
    }

    public static byte[] toByteArray(SequenceAcknowledgement obj) throws IOException {
        InputStream stream = PersistenceUtils.getInstance().serialiseAcknowledgment(obj);
        return org.apache.commons.io.IOUtils.toByteArray((InputStream)stream);
    }

    public static SequenceAcknowledgement toSequenceAcknowledgement(byte[] obj) {
        ByteArrayInputStream stream = new ByteArrayInputStream(obj);
        return PersistenceUtils.getInstance().deserialiseAcknowledgment((InputStream)stream);
    }

    public static void copyAndClose(byte[] input, OutputStream output) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(input);
        IOUtils.copyAndCloseInput((InputStream)stream, (OutputStream)output);
    }

    private static AddressingProperties buildCxfAddressingProperties(org.mule.soap.api.message.AddressingProperties addressingProperties) {
        AddressingProperties props = new AddressingProperties(addressingProperties.getNamespace());
        props.setTo(RMUtils.getAttributedURIType(addressingProperties.getTo()));
        props.setAction(RMUtils.getAttributedURIType(addressingProperties.getAction()));
        addressingProperties.getFrom().ifPresent(from -> props.setFrom(RMUtils.getEndpointReference(from)));
        addressingProperties.getMessageId().ifPresent(messageId -> props.setMessageID(RMUtils.getAttributedURIType(messageId)));
        addressingProperties.getRelatesTo().ifPresent(relatesTo -> props.setRelatesTo(RMUtils.getRelatesToType(relatesTo)));
        return props;
    }

    private static RelatesToType getRelatesToType(String value) {
        RelatesToType relatesTo = new RelatesToType();
        relatesTo.setValue(value);
        return relatesTo;
    }

    private static AttributedURIType getAttributedURIType(String value) {
        AttributedURIType type = new AttributedURIType();
        type.setValue(value);
        return type;
    }

    private static EndpointReferenceType getEndpointReference(String address) {
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setAddress(RMUtils.getAttributedURIType(address));
        return reference;
    }

    private RMUtils() {
    }
}

