/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security.configuration;

import java.util.List;
import java.util.Properties;
import org.mule.soap.api.security.configuration.WssPart;

public class WssSignConfiguration {
    private String signatureKeyIdentifier;
    private String signatureAlgorithm;
    private String signatureDigestAlgorithm;
    private String signatureC14nAlgorithm;
    private List<WssPart> wssParts;

    public WssSignConfiguration(String signatureKeyIdentifier, String signatureAlgorithm, String signatureDigestAlgorithm, String signatureC14nAlgorithm, List<WssPart> wssParts) {
        this.signatureKeyIdentifier = signatureKeyIdentifier;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureDigestAlgorithm = signatureDigestAlgorithm;
        this.signatureC14nAlgorithm = signatureC14nAlgorithm;
        this.wssParts = wssParts;
    }

    public String getSignatureKeyIdentifier() {
        return this.signatureKeyIdentifier;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getSignatureDigestAlgorithm() {
        return this.signatureDigestAlgorithm;
    }

    public String getSignatureC14nAlgorithm() {
        return this.signatureC14nAlgorithm;
    }

    public List<WssPart> getWssParts() {
        return this.wssParts;
    }

    public Properties getConfigurationProperties() {
        Properties properties = new Properties();
        if (this.signatureKeyIdentifier != null) {
            properties.setProperty("signatureKeyIdentifier", this.signatureKeyIdentifier);
        }
        if (this.signatureAlgorithm != null) {
            properties.setProperty("signatureAlgorithm", this.signatureAlgorithm);
        }
        if (this.signatureDigestAlgorithm != null) {
            properties.setProperty("signatureDigestAlgorithm", this.signatureDigestAlgorithm);
        }
        if (this.signatureC14nAlgorithm != null) {
            properties.setProperty("signatureC14nAlgorithm", this.signatureC14nAlgorithm);
        }
        if (this.wssParts != null) {
            StringBuilder sb = new StringBuilder();
            for (WssPart wssPart : this.wssParts) {
                sb.append(wssPart.toString());
            }
            properties.setProperty("signatureParts", sb.toString());
        }
        return properties;
    }
}

