/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.security.PasswordType;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssUsernameTokenSecurityStrategy
implements SecurityStrategy {
    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    public WssUsernameTokenSecurityStrategy(String user, String password, PasswordType passwordType, boolean addNonce, boolean addCreated) {
        this.username = user;
        this.password = password;
        this.passwordType = passwordType;
        this.addNonce = addNonce;
        this.addCreated = addCreated;
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return SecurityStrategy.SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(2, cb -> {
            if (cb.getIdentifier().equals(this.username)) {
                cb.setPassword(this.password);
            }
        }));
    }

    @Override
    public String securityAction() {
        return "UsernameToken";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"user", (Object)this.username).put((Object)"passwordType", (Object)this.passwordType.getType()).put((Object)"addUsernameTokenNonce", (Object)String.valueOf(this.addNonce)).put((Object)"addUsernameTokenCreated", (Object)String.valueOf(this.addNonce)).build();
    }
}

