/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.Once;

public class InputStreamWithEOFCallbackWrapper
extends InputStream {
    private final InputStream delegate;
    private final Once.RunOnce notifier;
    private static final int EOF_VALUE = -1;

    public InputStreamWithEOFCallbackWrapper(InputStream delegate, CheckedRunnable eofCallback) {
        this.delegate = delegate;
        this.notifier = Once.of((CheckedRunnable)eofCallback);
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.delegate.read();
        if (byteRead == -1) {
            this.notifier.runOnce();
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.delegate.read(b);
        if (bytesRead == -1) {
            this.notifier.runOnce();
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.delegate.read(b, off, len);
        if (bytesRead == -1) {
            this.notifier.runOnce();
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

