/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.db.commons.internal.util.ResultSetCharsetEncodedHandler;

public class ListResultSetHandler
implements ResultSetCharsetEncodedHandler {
    private final RowHandler rowHandler;
    private final Charset charset;

    public ListResultSetHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        this.charset = Charset.defaultCharset();
    }

    public ListResultSetHandler(RowHandler rowHandler, Charset charset) {
        this.rowHandler = rowHandler;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> processResultSet(DbConnection connection, ResultSet resultSet) throws SQLException {
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        try {
            while (resultSet.next()) {
                results.add(this.rowHandler.process(resultSet));
            }
        }
        finally {
            resultSet.close();
        }
        return results;
    }

    @Override
    public boolean requiresMultipleOpenedResults() {
        return false;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

