/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.StatementResult;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.api.param.QueryDefinition;
import org.mule.db.commons.api.param.QuerySettings;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysAttributes;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnIndexAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnNameAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.NoAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.executor.UpdateExecutor;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.domain.statement.QueryStatementFactory;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDbOperations {
    public static final int DEFAULT_FETCH_SIZE = 10;
    public static final String QUERY_GROUP = "Query";
    public static final String QUERY_SETTINGS = "Query Settings";
    protected final QueryResolver<ParameterizedStatementDefinition> queryResolver;
    protected final ConfigurableStatementFactory statementFactory;
    protected Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDbOperations.class);

    protected BaseDbOperations(QueryResolver<ParameterizedStatementDefinition> queryResolver, ConfigurableStatementFactory statementFactory, Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
        this.queryResolver = queryResolver;
        this.statementFactory = statementFactory;
        this.updateExecutor = updateExecutor;
    }

    protected static QueryResolver<ParameterizedStatementDefinition> getDefaultQueryResolver() {
        return new ParameterizedQueryResolver<ParameterizedStatementDefinition>();
    }

    protected static ConfigurableStatementFactory getDefaultStatementFactory() {
        return new QueryStatementFactory();
    }

    protected static Function<ConfigurableStatementFactory, QueryExecutor> getDefaultUpdateExecutor() {
        return UpdateExecutor::new;
    }

    protected ConfigurableStatementFactory getStatementFactory(QuerySettings settings) {
        int maxRows = settings.getMaxRows() != null ? settings.getMaxRows() : 0;
        int fetchSize = this.getFetchSize(settings);
        if (maxRows > 0) {
            fetchSize = Math.min(fetchSize, maxRows);
        }
        if (maxRows >= 0) {
            this.statementFactory.setMaxRows(maxRows);
        }
        this.statementFactory.setFetchSize(fetchSize);
        this.statementFactory.setQueryTimeout(BaseDbOperations.timeoutToSeconds(settings.getQueryTimeout(), settings.getQueryTimeoutUnit()));
        return this.statementFactory;
    }

    private static int timeoutToSeconds(int queryTimeout, TimeUnit sourceUnit) {
        long timeoutInSeconds = sourceUnit.toSeconds(queryTimeout);
        if (sourceUnit.convert(timeoutInSeconds, TimeUnit.SECONDS) < (long)queryTimeout) {
            LOGGER.warn("Timeout are rounded up to the next second.");
            ++timeoutInSeconds;
        }
        return Math.toIntExact(timeoutInSeconds);
    }

    protected StatementResult executeUpdate(QueryDefinition query, AutoGenerateKeysAttributes autoGenerateKeysAttributes, DbConnection connection, Query resolvedQuery) throws SQLException {
        ConfigurableStatementFactory localStatementFactory = this.getStatementFactory(query);
        return (StatementResult)this.updateExecutor.apply(localStatementFactory).execute(connection, resolvedQuery, this.getAutoGeneratedKeysStrategy(autoGenerateKeysAttributes));
    }

    protected Query resolveQuery(ParameterizedStatementDefinition<?> query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper, QueryType ... validTypes) {
        Query resolvedQuery = this.queryResolver.resolve(query, connector, connection, streamingHelper);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        this.validateNoParameterTypeIsUnused(resolvedQuery, query.getParameterTypes());
        return resolvedQuery;
    }

    protected void validateQueryType(QueryTemplate queryTemplate, List<QueryType> validTypes) {
        if (validTypes == null || !validTypes.contains((Object)queryTemplate.getType())) {
            String typeList = validTypes.stream().map(Enum::name).collect(Collectors.joining(", "));
            throw new BadSqlSyntaxException(String.format("Query type must be one of [%s] but query '%s' is of type '%s'", new Object[]{typeList, queryTemplate.getSqlText(), queryTemplate.getType()}));
        }
    }

    protected void validateNoParameterTypeIsUnused(Query query, List<ParameterType> parameterTypes) {
        Set params = query.getQueryTemplate().getParams().stream().map(QueryParam::getName).collect(Collectors.toSet());
        Set unusedTypes = parameterTypes.stream().map(ParameterType::getKey).filter(type -> !params.contains(type)).collect(Collectors.toSet());
        if (!unusedTypes.isEmpty()) {
            String msg = unusedTypes.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Query defines parameters [%s] but they aren't present in the query", msg));
        }
    }

    protected AutoGenerateKeysStrategy getAutoGeneratedKeysStrategy(AutoGenerateKeysAttributes keyAttributes) {
        if (keyAttributes == null) {
            return new NoAutoGenerateKeysStrategy();
        }
        if (keyAttributes.isAutoGenerateKeys()) {
            List<Integer> columnIndexes = keyAttributes.getAutoGeneratedKeysColumnIndexes();
            List<String> columnNames = keyAttributes.getAutoGeneratedKeysColumnNames();
            if (!CollectionUtils.isEmpty(columnIndexes)) {
                int[] indexes = new int[columnIndexes.size()];
                int i = 0;
                for (int index : columnIndexes) {
                    indexes[i++] = index;
                }
                return new ColumnIndexAutoGenerateKeysStrategy(indexes);
            }
            if (!CollectionUtils.isEmpty(columnNames)) {
                return new ColumnNameAutoGenerateKeysStrategy((String[])columnNames.stream().toArray(String[]::new));
            }
            return new DefaultAutoGenerateKeysStrategy();
        }
        return new NoAutoGenerateKeysStrategy();
    }

    protected int getFetchSize(QuerySettings settings) {
        Integer fetchSize = settings.getFetchSize();
        return fetchSize != null ? fetchSize : 10;
    }
}

